/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.diagnostics;

import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlHostnameMismatchException;
import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlPortMismatchException;
import com.atlassian.gadgets.dashboard.internal.diagnostics.UrlSchemeMismatchException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.base.Objects;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Diagnostics {
    private static final Logger log = LoggerFactory.getLogger(Diagnostics.class);
    private final ApplicationProperties application;

    @Autowired
    public Diagnostics(@ComponentImport ApplicationProperties application) {
        this.application = application;
    }

    public void check(URI clientDetectedUri) throws URISyntaxException, UrlSchemeMismatchException, UrlHostnameMismatchException, UrlPortMismatchException {
        log.info("DIAGNOSTICS: Running Dashboard Diagnostics");
        URI baseUri = new URI(this.application.getBaseUrl());
        int baseUriPort = this.getPort(baseUri);
        int clientDetectedUriPort = this.getPort(clientDetectedUri);
        this.checkExpectedScheme(clientDetectedUri.getScheme(), baseUri.getScheme());
        this.checkExpectedHostname(clientDetectedUri.getHost(), baseUri.getHost());
        this.checkExpectedPort(clientDetectedUriPort, baseUriPort);
        log.info("DIAGNOSTICS: All OK");
    }

    private int getPort(URI uri) {
        if (uri.getPort() == -1) {
            if (uri.getScheme().equals("http")) {
                return 80;
            }
            if (uri.getScheme().equals("https")) {
                return 443;
            }
        }
        return uri.getPort();
    }

    private void checkExpectedScheme(String expectedScheme, String detectedScheme) throws UrlSchemeMismatchException {
        log.info("SCHEME: Checking that the detected URL scheme, '{}', matches the expected scheme, '{}'", (Object)detectedScheme, (Object)expectedScheme);
        if (!Objects.equal((Object)expectedScheme, (Object)detectedScheme)) {
            throw new UrlSchemeMismatchException(expectedScheme, detectedScheme);
        }
        log.info("SCHEME: OK ({})", (Object)detectedScheme);
    }

    private void checkExpectedHostname(String expectedHostname, String detectedHostname) throws UrlHostnameMismatchException {
        log.info("HOST: Checking that the detected hostname, '{}', matches the expected hostname, '{}'", (Object)detectedHostname, (Object)expectedHostname);
        if (!Objects.equal((Object)expectedHostname, (Object)detectedHostname)) {
            throw new UrlHostnameMismatchException(expectedHostname, detectedHostname);
        }
        log.info("HOST: OK ({})", (Object)detectedHostname);
    }

    private void checkExpectedPort(int expectedPort, int detectedPort) throws UrlPortMismatchException {
        log.info("PORT: Checking that the detected port, '{}', matches the expected port, '{}'", (Object)detectedPort, (Object)expectedPort);
        if (expectedPort != detectedPort) {
            throw new UrlPortMismatchException(expectedPort, detectedPort);
        }
        log.info("PORT: OK ({})", (Object)detectedPort);
    }
}

