/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.DashboardItemState;
import com.atlassian.gadgets.dashboard.DashboardItemRepresentation;
import com.atlassian.gadgets.dashboard.DashboardItemRepresentationService;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.StateConverter;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetRepresentation;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RepresentationFactory;
import com.atlassian.gadgets.dashboard.internal.velocity.DashboardEmbedder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@ParametersAreNonnullByDefault
public final class DashboardItemRepresentationServiceImpl
implements DashboardItemRepresentationService {
    private final StateConverter stateConverter;
    private final RepresentationFactory representationFactory;
    private final DashboardEmbedder dashboardEmbedder;

    @Autowired
    public DashboardItemRepresentationServiceImpl(StateConverter stateConverter, RepresentationFactory representationFactory, DashboardEmbedder dashboardEmbedder) {
        this.stateConverter = stateConverter;
        this.representationFactory = representationFactory;
        this.dashboardEmbedder = dashboardEmbedder;
    }

    public Option<DashboardItemRepresentation> getRepresentation(DashboardItemState itemState, DashboardItemRepresentationService.RenderingContext context) {
        final Gadget gadget = this.stateConverter.convertStateToGadget(itemState, context.getRequestContext());
        if (!Strings.isNullOrEmpty((String)gadget.getErrorMessage())) {
            return Option.none();
        }
        Option<GadgetRepresentation> maybeRepresentation = this.representationFactory.createGadgetRepresentation(context.getDashboardId(), gadget, context.getRequestContext(), context.isWritable(), context.getColumnIndex());
        return maybeRepresentation.map((Function)new Function<GadgetRepresentation, DashboardItemRepresentation>(){

            public DashboardItemRepresentation apply(GadgetRepresentation gadgetRepresentation) {
                if (!Strings.isNullOrEmpty((String)gadgetRepresentation.getAMDModule()) || !Strings.isNullOrEmpty((String)gadgetRepresentation.getInlineHtml())) {
                    return DashboardItemRepresentation.dashboardItem((String)gadgetRepresentation.getAMDModule(), (String)gadgetRepresentation.getInlineHtml(), (String)DashboardItemRepresentationServiceImpl.this.dashboardEmbedder.representationToJson(gadgetRepresentation));
                }
                if (!Strings.isNullOrEmpty((String)gadgetRepresentation.getGadgetUrl())) {
                    return DashboardItemRepresentation.openSocialGadget((String)gadgetRepresentation.getGadgetUrl());
                }
                throw new IllegalStateException("Can't render dashboard item: " + gadget);
            }
        });
    }
}

