/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.usercontext.impl.embeddedcrowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.FecruComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.component.StashComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.web.usercontext.AuthenticationFailedException;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.SalPrincipalResolver;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.user.UserManager;
import java.security.Principal;
import javax.inject.Inject;

@JiraComponent
@BitbucketComponent
@StashComponent
@ConfluenceComponent
@FecruComponent
public class EmbeddedCrowdPrincipalResolver
extends SalPrincipalResolver {
    private final CrowdService crowdService;

    @Inject
    public EmbeddedCrowdPrincipalResolver(@ComponentImport UserManager userManager, @ComponentImport AuthenticationController authenticationController, @ComponentImport CrowdService crowdService) {
        super(userManager, authenticationController);
        this.crowdService = crowdService;
    }

    @Override
    protected Principal resolvePrincipal(String username) {
        try {
            this.crowdService.userAuthenticated(username);
            return super.resolvePrincipal(username);
        }
        catch (OperationFailedException e) {
            throw new AuthenticationFailedException("Error authenticating user", e);
        }
        catch (InactiveAccountException | UserNotFoundException throwable) {
            return null;
        }
    }
}

