/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.util;

import com.atlassian.plugins.authentication.impl.config.saml.InsecureUrlException;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.impl.web.InvalidLicenseException;
import com.atlassian.plugins.authentication.impl.web.saml.AuthenticationHandlerNotConfiguredException;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ApplicationStateValidator {
    private final HttpsValidator httpsValidator;
    private final SamlConfigService samlConfigService;
    private final ProductLicenseDataProvider productLicenseDataProvider;

    @Inject
    public ApplicationStateValidator(HttpsValidator httpsValidator, SamlConfigService samlConfigService, ProductLicenseDataProvider productLicenseDataProvider) {
        this.httpsValidator = httpsValidator;
        this.samlConfigService = samlConfigService;
        this.productLicenseDataProvider = productLicenseDataProvider;
    }

    public void checkCanConsumeSaml() {
        this.checkIsDataCenterProduct();
        this.checkSamlConfigIsConfigured();
        this.checkBaseUrlIsHttps();
    }

    public void checkCanProcessAuthenticationRequest() {
        this.checkIsDataCenterProduct();
        this.checkSamlConfigIsConfigured();
        this.checkBaseUrlIsHttps();
    }

    public void checkCanUpdateConfig() {
        this.checkIsDataCenterProduct();
        this.checkBaseUrlIsHttps();
    }

    private void checkBaseUrlIsHttps() {
        if (!this.httpsValidator.isBaseUrlSecure(this.samlConfigService.getSamlConfig())) {
            throw new InsecureUrlException("Base Url", "Base Url is not https");
        }
    }

    private void checkSamlConfigIsConfigured() {
        if (!this.samlConfigService.getSamlConfig().isConfigured()) {
            throw new AuthenticationHandlerNotConfiguredException("Invalid SAML configuration");
        }
    }

    private void checkIsDataCenterProduct() {
        if (!this.productLicenseDataProvider.isDataCenterProduct()) {
            throw new InvalidLicenseException("Current license is not data center");
        }
    }
}

