/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.saml;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.saml.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.saml.InvalidConfigException;
import com.atlassian.plugins.authentication.impl.rest.saml.model.ValidationResultEntity;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class InvalidConfigExceptionMapper
implements ExceptionMapper<InvalidConfigException> {
    private final I18nResolver i18nResolver;

    @Inject
    public InvalidConfigExceptionMapper(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(InvalidConfigException exception) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ValidationResultEntity(this.mapErrors(exception.getErrorsOnFields()))).build();
    }

    private Map<String, Collection<? super String>> mapErrors(Multimap<String, ErrorReason> errors) {
        HashMultimap result = HashMultimap.create();
        errors.entries().stream().map(this::mapErrorEntry).forEach(arg_0 -> InvalidConfigExceptionMapper.lambda$mapErrors$0((Multimap)result, arg_0));
        HashMap<String, Collection<? super String>> serializableMap = new HashMap<String, Collection<? super String>>();
        result.asMap().entrySet().forEach(e -> {
            Collection cfr_ignored_0 = serializableMap.put((String)e.getKey(), (Collection<? super String>)Arrays.asList(((Collection)e.getValue()).toArray()));
        });
        return serializableMap;
    }

    private Map.Entry<String, String> mapErrorEntry(Map.Entry<String, ErrorReason> entryToBeMapped) {
        ErrorReason errorReason = entryToBeMapped.getValue();
        String fieldName = entryToBeMapped.getKey();
        switch (errorReason) {
            case REQUIRED: {
                return this.mapMissingRequiredValueError(fieldName);
            }
            case INCORRECT: {
                return this.mapIncorrectValueError(fieldName);
            }
            case INSECURE: {
                return this.mapInsecureValueError(fieldName);
            }
        }
        return this.mapGenericError(fieldName);
    }

    private Map.Entry<String, String> mapInsecureValueError(String fieldName) {
        switch (fieldName) {
            case "sso-url": {
                return new AbstractMap.SimpleImmutableEntry<String, String>(fieldName, this.i18nResolver.getText("authentication.config.save.fail.sso.url.insecure"));
            }
        }
        return this.mapGenericError(fieldName);
    }

    private Map.Entry<String, String> mapIncorrectValueError(String fieldName) {
        switch (fieldName) {
            case "sso-url": {
                return new AbstractMap.SimpleImmutableEntry<String, String>(fieldName, this.i18nResolver.getText("authentication.config.save.fail.sso.url.malformed"));
            }
            case "certificate": {
                return new AbstractMap.SimpleImmutableEntry<String, String>(fieldName, this.i18nResolver.getText("authentication.config.save.fail.certificate.not.parsable"));
            }
        }
        return this.mapGenericError(fieldName);
    }

    private String mapFieldName(String fieldName) {
        switch (fieldName) {
            case "sso-url": {
                return this.i18nResolver.getText("authentication.config.save.fail.sso.url");
            }
            case "sso-issuer": {
                return this.i18nResolver.getText("authentication.config.save.fail.sso.issuer");
            }
            case "certificate": {
                return this.i18nResolver.getText("authentication.config.save.fail.certificate");
            }
        }
        return fieldName;
    }

    private Map.Entry<String, String> mapMissingRequiredValueError(String fieldName) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(fieldName, this.i18nResolver.getText("authentication.config.save.fail.field.missing", new Serializable[]{this.mapFieldName(fieldName)}));
    }

    private Map.Entry<String, String> mapGenericError(String fieldName) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(fieldName, this.i18nResolver.getText("authentication.config.save.fail.generic", new Serializable[]{this.mapFieldName(fieldName)}));
    }

    private static /* synthetic */ void lambda$mapErrors$0(Multimap result, Map.Entry e) {
        result.put(e.getKey(), e.getValue());
    }
}

