/**
 * Shifter group for admin search
 */
require([
    'jquery',
    'underscore',
    'jira/ajs/ajax/smart-ajax',
    'jira/shifter',
    'wrm/context-path'
], function (jQuery,
             _,
             SmartAjax,
             Shifter,
             contextPath) {
    Shifter.register(function () {
        var suggestionsDeferred = jQuery.Deferred();

        function formatItem(item) {
            return {
                label: item.label,
                value: item.linkUrl,
                keywords: item.aliases
            };
        }

        function getItemsInSection(section) {
            return _.map(section.items, formatItem).concat(_.map(section.sections, getItemsInSection));
        }

        function formatResponse(data) {
            return _.flatten(getItemsInSection(data));
        }

        SmartAjax.makeRequest({
            dataType: 'json',
            url: contextPath() + '/rest/adminquicksearch/latest/links/default'
        })
            .pipe(formatResponse)
            .done(function (suggestions) {
                suggestionsDeferred.resolve(suggestions);
            })
            .fail(function () {
                suggestionsDeferred.reject();
            });

        return {
            id: 'admin',
            name: AJS.I18n.getText('admin.quicksearch.title'),
            weight: 500,
            getSuggestions: function () {
                return suggestionsDeferred;
            },
            onSelection: function (value) {
                window.location = value;
                return jQuery.Deferred();
            }
        };
    });
});
