/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.rest;

import com.atlassian.administration.quicksearch.rest.LinkBean;
import com.atlassian.administration.quicksearch.rest.LocationBean;
import com.atlassian.administration.quicksearch.rest.LocationBeanUtils;
import com.atlassian.administration.quicksearch.rest.RemoteAdminLinksProvider;
import com.atlassian.administration.quicksearch.rest.SectionBean;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.applinks.core.AppLinksManager;
import com.atlassian.applinks.core.Application;
import com.atlassian.applinks.core.ApplicationInstance;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteAdminLinksProvider
implements RemoteAdminLinksProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteAdminLinksProvider.class);
    private static final Application[] SUPPORTED_APPS = new Application[0];
    private final RequestFactory<?> requestFactory;
    private final AppLinksManager appLinksManager;

    public DefaultRemoteAdminLinksProvider(RequestFactory<?> requestFactory, AppLinksManager appLinksManager) {
        this.requestFactory = requestFactory;
        this.appLinksManager = appLinksManager;
    }

    @Override
    public LocationBean getDefaultRemoteAdminLinks(UserContext context) {
        return this.getRemoteAdminLinksFor("default", context);
    }

    @Override
    public LocationBean getRemoteAdminLinksFor(String location, UserContext userContext) {
        ArrayList remoteLinks = Lists.newArrayList();
        for (ApplicationInstance instance : this.getApps()) {
            remoteLinks.add(this.getRemoteLinks(instance, location, userContext));
        }
        return LocationBeanUtils.merge(remoteLinks);
    }

    private LocationBean getRemoteLinks(ApplicationInstance instance, String location, UserContext userContext) {
        try {
            Request request = this.requestFactory.createRequest(Request.MethodType.GET, instance.getUrl() + "/rest/adminquicksearch/latest/local/links/" + location);
            request.setConnectionTimeout(5000);
            request.setSoTimeout(5000);
            request.addTrustedTokenAuthentication(userContext.getUsername());
            return this.makeAbsoluteLinks(instance, LocationBeanUtils.deserialize(request.execute()));
        }
        catch (Exception e) {
            log.warn("Exception while getting admin links from application " + instance.getUrl() + ": " + e);
            log.trace("Exception", (Throwable)e);
            return LocationBeanUtils.newEmptyBean();
        }
    }

    private Iterable<ApplicationInstance> getApps() {
        ArrayList instances = Lists.newArrayList();
        for (Application application : SUPPORTED_APPS) {
            instances.addAll(this.appLinksManager.getApplicationInstances(application).getAll().values());
        }
        return instances;
    }

    private LocationBean makeAbsoluteLinks(ApplicationInstance application, LocationBean locationBean) {
        for (LinkBean link : locationBean.links()) {
            this.makeAbsolute(application, link);
        }
        for (SectionBean section : locationBean.sections()) {
            this.makeAbsoluteLinks(application, section);
        }
        return locationBean;
    }

    private void makeAbsolute(ApplicationInstance application, LinkBean link) {
        if (this.isRelative(link.linkUrl)) {
            link.linkUrl = this.addBaseUrl(application, link.linkUrl);
        }
    }

    private String addBaseUrl(ApplicationInstance application, String linkUrl) {
        String appBaseUrl = application.getUrl();
        if (linkUrl.startsWith("/")) {
            int indexOfSecondSeparator = linkUrl.indexOf("/", 1);
            if (indexOfSecondSeparator > 0 && appBaseUrl.endsWith(linkUrl.substring(0, indexOfSecondSeparator))) {
                return appBaseUrl + linkUrl.substring(indexOfSecondSeparator);
            }
            return appBaseUrl + linkUrl;
        }
        return appBaseUrl + "/" + linkUrl;
    }

    private boolean isRelative(String linkUrl) {
        return !linkUrl.startsWith("http://") && !linkUrl.startsWith("https://");
    }
}

