/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.rest;

import com.atlassian.administration.quicksearch.rest.AbstractAdminLinkResource;
import com.atlassian.administration.quicksearch.rest.LocationBean;
import com.atlassian.administration.quicksearch.spi.AdminLinkManager;
import com.atlassian.administration.quicksearch.spi.AliasProviderConfiguration;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.administration.quicksearch.spi.UserContextProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class AdminLinkResourceSupport
extends AbstractAdminLinkResource {
    private final UserContextProvider userContextProvider;
    private final boolean stripRootSections;

    public AdminLinkResourceSupport(UserContextProvider userContextProvider, AdminLinkManager linkManager, AliasProviderConfiguration aliasProviderConfiguration) {
        this(userContextProvider, linkManager, aliasProviderConfiguration, true);
    }

    public AdminLinkResourceSupport(UserContextProvider userContextProvider, AdminLinkManager linkManager, AliasProviderConfiguration aliasProviderConfiguration, boolean stripRootSections) {
        super(linkManager, aliasProviderConfiguration.getAliasProvider());
        this.userContextProvider = userContextProvider;
        this.stripRootSections = stripRootSections;
    }

    public LocationBean getAdminLinks(String location, HttpServletRequest request) {
        this.checkLocation(location);
        return this.getAdminLinks((Iterable<String>)ImmutableList.of((Object)location), request);
    }

    public Response getAdminLinksResponse(String location, HttpServletRequest request) {
        return this.getSuccessfulResponse(this.getAdminLinks(location, request));
    }

    public LocationBean getAdminLinks(Iterable<String> locations, HttpServletRequest request) {
        UserContext userContext = this.userContextProvider.getUserContext(request);
        this.checkUser(userContext);
        this.checkLocations(locations);
        return this.getLinksFor(locations, userContext, this.stripRootSections);
    }

    public Response getAdminLinksResponse(Iterable<String> locations, HttpServletRequest request) {
        return this.getSuccessfulResponse(this.getAdminLinks(locations, request));
    }

    public Response getSuccessfulResponse(LocationBean locationBean) {
        return Response.ok((Object)locationBean).build();
    }

    private void checkUser(UserContext userContext) {
        if (userContext == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private void checkLocation(String location) {
        if (StringUtils.isEmpty(location)) {
            throw new WebApplicationException(this.badRequest("Parameter 'location' required"));
        }
    }

    private void checkLocations(Iterable<String> locations) {
        if (Iterables.isEmpty(locations)) {
            throw new WebApplicationException(this.badRequest("Parameter 'location' required"));
        }
    }

    public Response badRequest(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).cacheControl(this.never()).build();
    }

    private CacheControl never() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoStore(true);
        cacheControl.setNoCache(true);
        return cacheControl;
    }
}

