/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.web.condition;

import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JiraVersionGreaterThanOrEqual
implements Condition {
    private Integer minMajorVersion;
    private Integer minMinorVersion;
    private Integer majorVersion;
    private Integer minorVersion;

    public JiraVersionGreaterThanOrEqual(BuildUtilsInfo buildInfo) {
        String versionString = buildInfo.getVersion();
        String versionRegex = "^(\\d+)\\.(\\d+)";
        Pattern versionPattern = Pattern.compile(versionRegex);
        Matcher versionMatcher = versionPattern.matcher(versionString);
        versionMatcher.find();
        this.majorVersion = Integer.decode(versionMatcher.group(1));
        this.minorVersion = Integer.decode(versionMatcher.group(2));
    }

    public void init(Map<String, String> paramMap) throws PluginParseException {
        this.minMajorVersion = Integer.decode(paramMap.get("majorVersion"));
        this.minMinorVersion = Integer.decode(paramMap.get("minorVersion"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.majorVersion > this.minMajorVersion || this.majorVersion.equals(this.minMajorVersion) && this.minorVersion >= this.minMinorVersion;
    }
}

