/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.spi.alias;

import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkAliasProvider;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProjectLinkAliasProvider
implements AdminLinkAliasProvider {
    private static final String PROJECT_LINK_ID_PREFIX = "proj_lnk_";
    private static final Pattern REVERSE_ENGINEER = Pattern.compile("(.*)\\((.*)\\)(\\s)*");

    @Override
    public Set<String> getAliases(AdminLink link, Iterable<AdminLinkSection> parentSections, UserContext userContext) {
        Matcher matcher;
        String label;
        if (link.getId() != null && link.getId().startsWith(PROJECT_LINK_ID_PREFIX) && (label = link.getLabel()) != null && (matcher = REVERSE_ENGINEER.matcher(link.getLabel())).matches()) {
            return ImmutableSet.of((Object)matcher.group(1).trim(), (Object)matcher.group(2).trim());
        }
        return Collections.emptySet();
    }
}

