/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.spi;

import com.atlassian.administration.quicksearch.jira.spi.JiraUserContext;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

final class JiraContextHelper {
    private final UserContext userContext;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    static JiraHelper createJiraHelper(HttpServletRequest request, Map<String, Object> contextMap) {
        return new JiraHelper(request, JiraContextHelper.getProject(contextMap), contextMap);
    }

    private static Project getProject(Map<String, Object> contextMap) {
        if (contextMap.containsKey("project")) {
            return (Project)contextMap.get("project");
        }
        return null;
    }

    JiraContextHelper(UserContext userContext, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userContext = userContext;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    ApplicationUser getUser() {
        return this.userContext instanceof JiraUserContext ? ((JiraUserContext)JiraUserContext.class.cast(this.userContext)).getUser() : this.jiraAuthenticationContext.getUser();
    }

    JiraHelper getJiraHelper() {
        return this.userContext instanceof JiraUserContext ? ((JiraUserContext)JiraUserContext.class.cast(this.userContext)).getJiraHelper() : JiraContextHelper.createJiraHelper(this.userContext.getRequest(), this.userContext.getContextMap());
    }
}

