/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.jira.spi;

import com.atlassian.administration.quicksearch.jira.spi.JiraAdminLinkSection;
import com.atlassian.administration.quicksearch.jira.spi.JiraContextHelper;
import com.atlassian.administration.quicksearch.jira.spi.SimpleLinkProvider;
import com.atlassian.administration.quicksearch.spi.AdminLinkManager;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Preconditions;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAdminLinkManager
implements AdminLinkManager {
    private static final Logger log = LoggerFactory.getLogger(JiraAdminLinkManager.class);
    private final SimpleLinkProvider simpleLinkProvider;
    private final JiraAuthenticationContext authenticationContext;

    public JiraAdminLinkManager(SimpleLinkProvider simpleLinkProvider, JiraAuthenticationContext authenticationContext) {
        this.simpleLinkProvider = (SimpleLinkProvider)Preconditions.checkNotNull((Object)simpleLinkProvider, (Object)"simpleLinkProvider");
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext, (Object)"authenticationContext");
    }

    @Override
    @Nonnull
    public AdminLinkSection getSection(String location, UserContext userContext) {
        JiraContextHelper helper = new JiraContextHelper(userContext, this.authenticationContext);
        return new JiraAdminLinkSection((SimpleLinkSection)this.rootSection(location), this.simpleLinkProvider, userContext, helper);
    }

    private SimpleLinkSectionImpl rootSection(String location) {
        return new SimpleLinkSectionImpl(location, null, null, null, null, Collections.emptyMap());
    }
}

