/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.impl.spi.alias;

import com.atlassian.administration.quicksearch.impl.spi.AbstractDefaultAdminWebItem;
import com.atlassian.administration.quicksearch.impl.spi.alias.StaticAliasProviderHelper;
import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkAliasProvider;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.UserContext;
import com.atlassian.plugin.event.PluginEventManager;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class StaticParamAliasProvider
implements AdminLinkAliasProvider {
    public static final String DEFAULT_PARAM_NAME = "atlassian.link.aliases";
    private final String paramName;
    private final StaticAliasProviderHelper helper;

    public StaticParamAliasProvider(String paramName, PluginEventManager eventManager) {
        this.paramName = (String)Preconditions.checkNotNull((Object)paramName, (Object)"paramName");
        this.helper = new StaticAliasProviderHelper();
        eventManager.register((Object)this.helper);
    }

    public StaticParamAliasProvider(PluginEventManager eventManager) {
        this(DEFAULT_PARAM_NAME, eventManager);
    }

    public StaticParamAliasProvider(String paramName, StaticAliasProviderHelper aliasHelper, PluginEventManager eventManager) {
        this.paramName = (String)Preconditions.checkNotNull((Object)paramName, (Object)"paramName");
        this.helper = aliasHelper;
        eventManager.register((Object)this.helper);
    }

    public StaticParamAliasProvider(StaticAliasProviderHelper aliasHelper, PluginEventManager eventManager) {
        this(DEFAULT_PARAM_NAME, aliasHelper, eventManager);
    }

    @Override
    public Set<String> getAliases(AdminLink link, Iterable<AdminLinkSection> parentSections, UserContext userContext) {
        String aliasesKey = link.getParameters().get(this.paramName);
        if (StringUtils.isEmpty(aliasesKey)) {
            aliasesKey = this.getPluginKey(link);
        }
        if (StringUtils.isEmpty(aliasesKey)) {
            return StaticAliasProviderHelper.EMPTY_KEYWORDS;
        }
        return this.helper.aliasesFor(aliasesKey, userContext);
    }

    private String getPluginKey(AdminLink link) {
        String key;
        if (link instanceof AbstractDefaultAdminWebItem && !StringUtils.isEmpty(key = ((AbstractDefaultAdminWebItem)AbstractDefaultAdminWebItem.class.cast(link)).getCompleteKey())) {
            return this.paramName + "." + key.replace(":", ".").replace("-", ".");
        }
        return null;
    }
}

