/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.administration.quicksearch.impl.spi;

import com.atlassian.administration.quicksearch.impl.spi.DefaultAdminLink;
import com.atlassian.administration.quicksearch.impl.spi.DefaultAdminLinkSection;
import com.atlassian.administration.quicksearch.spi.AdminLink;
import com.atlassian.administration.quicksearch.spi.AdminLinkSection;
import com.atlassian.administration.quicksearch.spi.RenderingContext;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

public final class DefaultAdminWebItems {
    private DefaultAdminWebItems() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static Function<WebItemModuleDescriptor, AdminLink> toLink(final RenderingContext context) {
        return new Function<WebItemModuleDescriptor, AdminLink>(){

            public AdminLink apply(WebItemModuleDescriptor descriptor) {
                return new DefaultAdminLink(descriptor, context);
            }
        };
    }

    public static Function<WebSectionModuleDescriptor, AdminLinkSection> toSection(final RenderingContext renderingContext, final WebInterfaceManager webInterfaceManager) {
        return new Function<WebSectionModuleDescriptor, AdminLinkSection>(){

            public AdminLinkSection apply(WebSectionModuleDescriptor descriptor) {
                return new DefaultAdminLinkSection(descriptor, renderingContext, webInterfaceManager);
            }
        };
    }

    public static Function<WebSectionModuleDescriptor, AdminLinkSection> toSection(final RenderingContext renderingContext, final WebInterfaceManager webInterfaceManager, final @Nullable Predicate<AdminLink> linkFilter, final @Nullable Predicate<AdminLinkSection> sectionFilter) {
        return new Function<WebSectionModuleDescriptor, AdminLinkSection>(){

            public AdminLinkSection apply(WebSectionModuleDescriptor descriptor) {
                return new DefaultAdminLinkSection(descriptor, renderingContext, webInterfaceManager, (Predicate<AdminLink>)linkFilter, (Predicate<AdminLinkSection>)sectionFilter);
            }
        };
    }

    public static Supplier<Iterable<AdminLinkSection>> childSections(final String location, final RenderingContext userContext, final WebInterfaceManager webInterfaceManager, final @Nullable Predicate<AdminLink> linkFilter, final @Nullable Predicate<AdminLinkSection> sectionFilter) {
        return new Supplier<Iterable<AdminLinkSection>>(){

            public Iterable<AdminLinkSection> get() {
                ImmutableList sections = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)webInterfaceManager.getDisplayableSections(location, userContext.getContextMap()), DefaultAdminWebItems.toSection(userContext, webInterfaceManager, (Predicate<AdminLink>)linkFilter, (Predicate<AdminLinkSection>)sectionFilter)));
                return Iterables.filter((Iterable)sections, (Predicate)(sectionFilter != null ? sectionFilter : Predicates.alwaysTrue()));
            }
        };
    }

    public static Supplier<Iterable<AdminLink>> childLinks(final String section, final RenderingContext renderingContext, final WebInterfaceManager webInterfaceManager, final @Nullable Predicate<AdminLink> linkFilter) {
        return new Supplier<Iterable<AdminLink>>(){

            public Iterable<AdminLink> get() {
                ImmutableList links = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)webInterfaceManager.getDisplayableItems(section, renderingContext.getContextMap()), DefaultAdminWebItems.toLink(renderingContext)));
                return Iterables.filter((Iterable)links, (Predicate)(linkFilter != null ? linkFilter : Predicates.alwaysTrue()));
            }
        };
    }

    public static Supplier<Iterable<AdminLinkSection>> childSections(String location, RenderingContext userContext, WebInterfaceManager webInterfaceManager) {
        return DefaultAdminWebItems.childSections(location, userContext, webInterfaceManager, null, null);
    }

    public static Supplier<Iterable<AdminLink>> childLinks(String section, RenderingContext renderingContext, WebInterfaceManager webInterfaceManager) {
        return DefaultAdminWebItems.childLinks(section, renderingContext, webInterfaceManager, null);
    }
}

