/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.status;

import com.atlassian.applinks.internal.common.rest.model.status.RestOAuthConfig;
import com.atlassian.applinks.internal.common.status.oauth.OAuthConfig;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.RestRepresentation;
import com.atlassian.applinks.internal.status.oauth.ApplinkOAuthStatus;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestApplinkOAuthStatus
extends BaseRestEntity
implements RestRepresentation<ApplinkOAuthStatus> {
    public static final String INCOMING = "incoming";
    public static final String OUTGOING = "outgoing";

    public RestApplinkOAuthStatus() {
    }

    public RestApplinkOAuthStatus(@Nonnull Map<String, Object> original) {
        super(original);
    }

    public RestApplinkOAuthStatus(@Nonnull ApplinkOAuthStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        this.put(INCOMING, (Object)new RestOAuthConfig(status.getIncoming()));
        this.put(OUTGOING, (Object)new RestOAuthConfig(status.getOutgoing()));
    }

    @Override
    @Nonnull
    public ApplinkOAuthStatus asDomain() {
        OAuthConfig incoming = (OAuthConfig)this.getRequiredDomain(INCOMING, RestOAuthConfig.class);
        OAuthConfig outgoing = (OAuthConfig)this.getRequiredDomain(OUTGOING, RestOAuthConfig.class);
        return new ApplinkOAuthStatus(incoming, outgoing);
    }
}

