/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model;

import com.atlassian.applinks.internal.common.exception.DetailedErrors;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.RestError;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class RestErrors
extends BaseRestEntity {
    public static final String STATUS = "status";
    public static final String ERRORS = "errors";

    public RestErrors(@Nonnull Response.Status status, @Nonnull Iterable<RestError> errors) {
        this.put(STATUS, (Object)((Response.Status)Preconditions.checkNotNull((Object)status, (Object)STATUS)).getStatusCode());
        this.put(ERRORS, Preconditions.checkNotNull(errors, (Object)ERRORS));
    }

    public RestErrors(@Nonnull Response.Status status, @Nonnull DetailedErrors errors) {
        this.put(STATUS, (Object)((Response.Status)Preconditions.checkNotNull((Object)status, (Object)STATUS)).getStatusCode());
        this.putIterableOf(ERRORS, ((DetailedErrors)Preconditions.checkNotNull((Object)errors, (Object)ERRORS)).getErrors(), RestError.class);
    }

    public RestErrors(@Nonnull Response.Status status, @Nonnull RestError error) {
        this(status, (Iterable<RestError>)ImmutableList.of((Object)error));
    }

    public RestErrors(@Nonnull Response.Status status, @Nonnull String summary) {
        this(status, new RestError(summary));
    }

    public RestErrors(@Nonnull Response.Status status, @Nonnull Exception javaError) {
        this(status, new RestError(javaError));
    }
}

