/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.rest.ui;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.manifest.AppLinksManifestDownloader;
import com.atlassian.applinks.core.rest.AbstractResource;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksInterceptor;
import com.atlassian.applinks.core.rest.context.ContextInterceptor;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.internal.rest.interceptor.NoCacheHeaderInterceptor;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ApplicationStatus;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.plugins.rest.common.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import com.sun.jersey.spi.resource.Singleton;
import java.io.Serializable;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="relocateApplicationlink")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@InterceptorChain(value={ContextInterceptor.class, AdminApplicationLinksInterceptor.class, NoCacheHeaderInterceptor.class})
public class RelocateApplicationLinkUIResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(RelocateApplicationLinkUIResource.class);
    private final MutatingApplicationLinkService applicationLinkService;
    private final ManifestRetriever manifestRetriever;
    private final AppLinksManifestDownloader manifestDownloader;
    private final I18nResolver i18nResolver;
    private final UserManager userManager;

    public RelocateApplicationLinkUIResource(RestUrlBuilder restUrlBuilder, MutatingApplicationLinkService applicationLinkService, I18nResolver i18nResolver, ManifestRetriever manifestRetriever, AppLinksManifestDownloader manifestDownloader, InternalTypeAccessor internalTypeAccessor, RequestFactory requestFactory, UserManager userManager) {
        super(restUrlBuilder, internalTypeAccessor, requestFactory, applicationLinkService);
        this.applicationLinkService = applicationLinkService;
        this.i18nResolver = i18nResolver;
        this.manifestRetriever = manifestRetriever;
        this.manifestDownloader = manifestDownloader;
        this.userManager = userManager;
    }

    @POST
    @Path(value="{applinkId}")
    public Response relocate(@PathParam(value="applinkId") String applicationId, @QueryParam(value="newUrl") String urlString, @QueryParam(value="nowarning") boolean nowarning) throws TypeNotInstalledException {
        URI url;
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return RestUtil.forbidden(this.i18nResolver.getText("applinks.error.only.sysadmin.operation"));
        }
        MutableApplicationLink link = this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
        try {
            url = URIUtil.uncheckedToUri(urlString);
        }
        catch (RuntimeException e) {
            return RestUtil.serverError(e.getMessage());
        }
        if (link == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{applicationId}));
        }
        if (this.manifestRetriever.getApplicationStatus(url, link.getType()) == ApplicationStatus.UNAVAILABLE) {
            if (nowarning) {
                return this.update(link, url, url);
            }
            return Response.status((int)409).build();
        }
        URI displayUrl = url;
        try {
            Manifest manifest = this.manifestDownloader.download(url);
            if (!this.typeAccessor.loadApplicationType(manifest.getTypeId()).equals(link.getType())) {
                return Response.status((int)400).entity((Object)this.i18nResolver.getText("applinks.error.relocate.type", new Serializable[]{urlString, this.i18nResolver.getText(this.typeAccessor.loadApplicationType(manifest.getTypeId()).getI18nKey()), this.i18nResolver.getText(link.getType().getI18nKey())})).build();
            }
            displayUrl = manifest.getUrl();
        }
        catch (ManifestNotFoundException manifestNotFoundException) {
            // empty catch block
        }
        return this.update(link, url, displayUrl);
    }

    private Response update(MutableApplicationLink link, URI rpcUrl, URI displayUrl) {
        link.update(ApplicationLinkDetails.builder((ApplicationLink)link).rpcUrl(rpcUrl).displayUrl(displayUrl).build());
        LOG.info("Changed RPC URL from {} to {} and display URL from {} to {} for ApplicationLink {} .", new Object[]{link.getRpcUrl().toString(), rpcUrl.toString(), link.getDisplayUrl().toString(), displayUrl.toString(), link.getId()});
        return RestUtil.noContent();
    }
}

