/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.link;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.core.link.DefaultEntityLink;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.spi.link.EntityLinkBuilderFactory;
import com.google.common.base.Preconditions;

public class DefaultEntityLinkBuilderFactory
implements EntityLinkBuilderFactory {
    private final PropertyService propertyService;

    public DefaultEntityLinkBuilderFactory(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    public EntityLinkBuilderFactory.EntityLinkBuilder builder() {
        return new DefaultEntityLinkBuilder();
    }

    public class DefaultEntityLinkBuilder
    implements EntityLinkBuilderFactory.EntityLinkBuilder {
        private ApplicationLink applicationLink;
        private EntityType type;
        private String key;
        private String name;
        private boolean primary = false;

        public EntityLinkBuilderFactory.EntityLinkBuilder key(String key) {
            this.key = key;
            return this;
        }

        public EntityLinkBuilderFactory.EntityLinkBuilder type(EntityType type) {
            this.type = type;
            return this;
        }

        public EntityLinkBuilderFactory.EntityLinkBuilder applicationLink(ApplicationLink applicationLink) {
            this.applicationLink = applicationLink;
            return this;
        }

        public EntityLinkBuilderFactory.EntityLinkBuilder primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        public EntityLinkBuilderFactory.EntityLinkBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EntityLink build() {
            if (this.name == null) {
                this.name = this.key;
            }
            return new DefaultEntityLink((String)Preconditions.checkNotNull((Object)this.key, (Object)"key"), (EntityType)Preconditions.checkNotNull((Object)this.type, (Object)"type"), (String)Preconditions.checkNotNull((Object)this.name, (Object)"name"), this.type.getDisplayUrl((ApplicationLink)Preconditions.checkNotNull((Object)this.applicationLink), this.key), (ApplicationLink)Preconditions.checkNotNull((Object)this.applicationLink, (Object)"applicationLink"), DefaultEntityLinkBuilderFactory.this.propertyService, this.primary);
        }
    }
}

