(function ($) {
    var contextPath =
        typeof AJS.contextPath == "function" ? AJS.contextPath() :
        typeof AJS.Confluence != "undefined" ? AJS.Confluence.getContextPath() :
        window.contextPath != null ? window.contextPath : "";

    var sendRedrawMessage = function () {
        // Using common AUI message close event to broadcast that the screen should be redrawn
        AJS.$(document).trigger("aui-message-close");
    };

    AJS.toInit(function ($) {
        var $appNameMeta = $("meta[name='application-name']");
        var appName = $appNameMeta.attr("content");

        var performRedraw = true;

        if (!appName) {
            appName = "Confluence";
        }

        var displayName = appName;

        var bannerLocation = {
            position: "#main",
            insert: "prepend"
        };

        if (appName == "JIRA") {
            bannerLocation.position = "#content";
        }

        if (appName == "Stash") {
            bannerLocation.position = "#content .aui-page-panel-content";
        }

        if (appName == "Bitbucket") {
            bannerLocation.position = "#content .aui-page-panel-content";
        }

        if (appName == "fecru") {
            bannerLocation.position = "#content";
            displayName = $appNameMeta.attr("display-name");
        }

        if (appName == "Bamboo") {
            bannerLocation.position = "#content";
            performRedraw = false;
        }

        AJS.messages.warning(bannerLocation.position, {
            title: "Important changes to our Privacy Policy",
            body: "<p>" + AJS.format("We are continuously working to make {0} better. Data about how you use {0} helps us do that. " +
                                     "We have updated our Privacy Policy so that we may collect usage data automatically unless you disable collection. " +
                                     "The data we collect includes information about the systems on which your installation of {0} is operating, " +
                                     "the features you use in {0}, and your use of common IT terminology within the product.", displayName) + "</p>" +
                  "<p><ul><li>" + AJS.format("View an <a href=\"{0}/plugins/servlet/analytics/sample\">example</a> of the type of data we collect.", contextPath) + "</li>" +
                  "<li>" + AJS.format("Once you click to acknowledge the new Privacy Policy, data collection will be enabled unless you " +
                                      "<a href=\"{0}/plugins/servlet/analytics/configuration\">change your settings</a>, " +
                                      "which you may do at any time.", contextPath) + "</li></ul></p>" +
                  "<p>" + AJS.format("Please review our updated " +
                                     "<a href=\"http://www.atlassian.com/company/privacy?utm_source={0}&utm_medium=privacy-policy-banner&utm_campaign=privacy-policy\" target=\"_blank\">", displayName) +
                                     "Privacy Policy</a> for details on the usage data we collect." + "</p>" +
                  "<p><button id=\"policy-update-acknowledge\" class=\"aui-button aui-button-primary\">" + "Acknowledge changes to the privacy policy" + "</button></p>",
            id: "policy-update-message",
            insert: bannerLocation.insert,
            closeable: false,
            shadowed: true
        });
        if (performRedraw) {
            sendRedrawMessage();
        }

        $("#policy-update-acknowledge").on("click", function() {
            $.ajax({
                       url: contextPath + "/rest/analytics/1.0/config/acknowledge",
                       type: "PUT",
                       data: "policyAcknowledged=true",
                       success: function () {
                           AJS.trigger('analytics-policy-acknowledged');
                           $("#policy-update-message").fadeOut(500, function() {
                               $("#policy-update-message").remove();
                               if (performRedraw) {
                                   sendRedrawMessage();
                               }
                           });
                       },
                       error: function() {
                           AJS.messages.error("#policy-update-message", {
                               body: "Acknowledgement could not be saved, check your connection with the server.",
                               id: "config-update-failed",
                               insert: "append",
                               closeable: false,
                               shadowed: true
                           });
                           $(".aui-message#config-update-failed").delay(2000).fadeOut(500, function () {
                               $("#config-update-failed").remove();
                               if (performRedraw) {
                                   sendRedrawMessage();
                               }
                           });
                       }
                   });
        });
    });
})(AJS.$);
