/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.activeobjects.internal;

import com.atlassian.activeobjects.internal.DriverNameExtractor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.java.ao.ActiveObjectsException;

public final class DriverNameExtractorImpl
implements DriverNameExtractor {
    @Override
    public String getDriverName(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String string = connection.getMetaData().getDriverName();
            return string;
        }
        catch (SQLException e) {
            throw new ActiveObjectsException(e);
        }
        finally {
            DriverNameExtractorImpl.closeQuietly(connection);
        }
    }

    private static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

