/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.visiblefortesting;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.error.ErrorHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.ComposedAlgorithm;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithmFactory;
import com.atlassian.servicedesk.plugins.search.visiblefortesting.RequestTypeSearchAlgorithmTestBackdoor;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
@VisibleForTesting
public class RequestTypeSearchAlgorithmTestBackdoorImpl
implements RequestTypeSearchAlgorithmTestBackdoor {
    private Logger log = Logger.getLogger(RequestTypeSearchAlgorithmTestBackdoor.class);
    private final RequestTypeSearchAlgorithmFactory requestTypeSearchAlgorithmFactory;
    private final ErrorHelper errorHelper;

    @Autowired
    public RequestTypeSearchAlgorithmTestBackdoorImpl(RequestTypeSearchAlgorithmFactory requestTypeSearchAlgorithmFactory, ErrorHelper errorHelper) {
        this.requestTypeSearchAlgorithmFactory = requestTypeSearchAlgorithmFactory;
        this.errorHelper = errorHelper;
    }

    @Override
    @Nonnull
    public Either<AnError, RequestTypeSearchResultList> searchWithAlgorithmId(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery requestTypeSearchQuery, @Nonnull String id, @Nullable Integer primaryAlgorithmLimit) {
        Option<RequestTypeSearchAlgorithm> algorithmByIdOption = this.getAlgorithmById(id, primaryAlgorithmLimit);
        if (algorithmByIdOption.isEmpty()) {
            return this.errorHelper.algorithmNotFound(id);
        }
        RequestTypeSearchAlgorithm requestTypeSearchAlgorithm = (RequestTypeSearchAlgorithm)algorithmByIdOption.get();
        return requestTypeSearchAlgorithm.search(user, requestTypeSearchQuery);
    }

    private Option<RequestTypeSearchAlgorithm> getAlgorithmById(@Nonnull String id, @Nullable Integer primaryAlgorithmLimit) {
        if (id.contains("+")) {
            String[] algorithmIds = id.split("\\+");
            if (algorithmIds.length > 2) {
                throw new RuntimeException("Cannot combine more than 2 algorithms");
            }
            Option<RequestTypeSearchAlgorithm> primaryAlgo = this.getAlgorithmById(algorithmIds[0], null);
            Option<RequestTypeSearchAlgorithm> secondaryAlgo = this.getAlgorithmById(algorithmIds[1], null);
            if (primaryAlgo.isEmpty() || secondaryAlgo.isEmpty()) {
                return Option.none();
            }
            ComposedAlgorithm composedAlgorithm = new ComposedAlgorithm((RequestTypeSearchAlgorithm)primaryAlgo.get(), primaryAlgorithmLimit, (RequestTypeSearchAlgorithm)secondaryAlgo.get());
            return Option.option((Object)composedAlgorithm);
        }
        switch (id) {
            case "0": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getGlobalRequestTypeAlgorithm());
            }
            case "1": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getBasicAlgorithm());
            }
            case "2": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getSummaryJqlAlgorithm());
            }
            case "3": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getSummaryDescriptionJqlAlgorithm());
            }
            case "0v2": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getGlobalRequestTypeSearchAlgorithmTwo());
            }
            case "1v2": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getBasicRequestTypeSearchAlgorithmTwo());
            }
            case "1v3": {
                return Option.option((Object)this.requestTypeSearchAlgorithmFactory.getBasicRequestTypeSearchAlgorithmThree());
            }
        }
        return Option.none();
    }
}

