/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

class RequestTypeSearchDataCallback
extends Collector {
    private final FieldSelector vpOriginFieldSelector;
    @TenantAware(value=TenancyScope.TENANTED)
    private final Map<String, Integer> requestTypesCount = Maps.newHashMap();
    private final String customFieldId;
    private IndexReader indexReader = null;

    RequestTypeSearchDataCallback(Long vpOriginId) {
        this.customFieldId = "customfield_" + vpOriginId;
        this.vpOriginFieldSelector = new SingleFieldSelector(this.customFieldId);
    }

    public List<Map.Entry<String, Integer>> getSortedRequestTypeCount() {
        ArrayList list = Lists.newArrayList(this.requestTypesCount.entrySet());
        Collections.sort(list, (o1, o2) -> Long.compare(((Integer)o2.getValue()).intValue(), ((Integer)o1.getValue()).intValue()));
        return list;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int i) throws IOException {
        Document document;
        Fieldable customField;
        String value;
        if (this.indexReader != null && StringUtils.isNotBlank((String)(value = (customField = (document = this.indexReader.document(i, this.vpOriginFieldSelector)).getFieldable(this.customFieldId)).stringValue()))) {
            if (this.requestTypesCount.containsKey(value)) {
                this.requestTypesCount.put(value, this.requestTypesCount.get(value) + 1);
            } else {
                this.requestTypesCount.put(value, 1);
            }
        }
    }

    public void setNextReader(IndexReader indexReader, int i) throws IOException {
        this.indexReader = indexReader;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private static class SingleFieldSelector
    implements FieldSelector {
        private final String fieldName;

        private SingleFieldSelector(@Nonnull String fieldName) {
            this.fieldName = fieldName;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (this.fieldName.equals(fieldName)) {
                return FieldSelectorResult.LOAD_AND_BREAK;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }
}

