/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base;

import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

class RequestTypeCustomFieldData {
    private final String requestTypeKey;
    private final String portalKey;

    static Option<RequestTypeCustomFieldData> parse(@Nonnull String vpOriginCfValue) {
        String[] split = vpOriginCfValue.split("/");
        if (split.length != 2) {
            return Option.none();
        }
        String portalKey = split[0];
        String requestTypeKey = split[1];
        if (StringUtils.isBlank((CharSequence)requestTypeKey) || StringUtils.isBlank((CharSequence)portalKey)) {
            return Option.none();
        }
        return Option.some((Object)new RequestTypeCustomFieldData(requestTypeKey, portalKey));
    }

    private RequestTypeCustomFieldData(@Nonnull String requestTypeKey, @Nonnull String portalKey) {
        this.requestTypeKey = requestTypeKey;
        this.portalKey = portalKey;
    }

    @Nonnull
    public String getRequestTypeKey() {
        return this.requestTypeKey;
    }

    @Nonnull
    public String getPortalKey() {
        return this.portalKey;
    }
}

