/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.plugins.search.error.ErrorHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.RequestTypeSearchDataCallback;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Collector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JQLRequestTypeSearcher {
    private final SearchProvider searchProvider;
    private final ErrorHelper errorHelper;

    @Autowired
    public JQLRequestTypeSearcher(SearchProvider searchProvider, ErrorHelper errorHelper) {
        this.searchProvider = searchProvider;
        this.errorHelper = errorHelper;
    }

    public Either<AnError, Set<String>> performSearch(Query query, long vpOriginId, int numberOfIssuesToSearchFor) {
        RequestTypeSearchDataCallback requestTypeSearchDataCallback = new RequestTypeSearchDataCallback(vpOriginId);
        try {
            this.searchProvider.searchAndSortOverrideSecurity(query, (ApplicationUser)null, (Collector)requestTypeSearchDataCallback, PagerFilter.newPageAlignedFilter((int)0, (int)numberOfIssuesToSearchFor));
        }
        catch (SearchException ex) {
            return this.errorHelper.errorSearching((Exception)((Object)ex));
        }
        return Either.right(this.getSortedSetOfVpOriginsFromSearchResults(requestTypeSearchDataCallback));
    }

    private Set<String> getSortedSetOfVpOriginsFromSearchResults(RequestTypeSearchDataCallback requestTypeSearchDataCallback) {
        List<Map.Entry<String, Integer>> sortedRequestTypeCount = requestTypeSearchDataCallback.getSortedRequestTypeCount();
        return Sets.newLinkedHashSet((Iterable)sortedRequestTypeCount.stream().map(Map.Entry::getKey).collect(Collectors.toList()));
    }
}

