/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.internal.api.requesttype.customfield.RequestTypeCustomFieldService;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeServiceHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.AbstractJQLRequestTypeSearchAlgorithm;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.JQLRequestTypeSearcher;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SummaryJQLRequestTypeSearchAlgorithm
extends AbstractJQLRequestTypeSearchAlgorithm {
    @Autowired
    public SummaryJQLRequestTypeSearchAlgorithm(JQLRequestTypeSearcher jqlRequestTypeSearcher, ProjectService projectService, PortalService portalService, RequestTypeCustomFieldService requestTypeCustomFieldService, ServiceDeskService serviceDeskService, RequestTypeServiceHelper requestTypeServiceHelper) {
        super(jqlRequestTypeSearcher, projectService, portalService, requestTypeCustomFieldService, serviceDeskService, requestTypeServiceHelper);
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Performs a JQL search with tokenised search terms to find the most used request types among the returned issues. The JQL looks like \"(summary ~ term1 OR summary ~ term2 ... OR summary ~ termN) AND vp.origin IS NOT EMPTY\"";
    }

    @Override
    @Nonnull
    protected Query getJqlQueryForSearchTerm(@Nonnull String searchTerms, long vpOriginId, @Nonnull Option<ServiceDesk> serviceDeskOption) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder clauseBuilder = this.newClauseBuilderWithSearchTermClause(searchTerms);
        this.addCustomFieldClause(clauseBuilder, vpOriginId);
        this.addServiceDeskClause(clauseBuilder, serviceDeskOption);
        return jqlQueryBuilder.where().addClause(clauseBuilder.buildClause()).endWhere().orderBy().createdDate(SortOrder.DESC).endOrderBy().buildQuery();
    }

    private JqlClauseBuilder newClauseBuilderWithSearchTermClause(String searchTerms) {
        JqlClauseBuilder clauseBuilder = JqlQueryBuilder.newClauseBuilder();
        String[] terms = searchTerms.split(" ");
        clauseBuilder.sub();
        for (int i = 0; i < terms.length; ++i) {
            String term = terms[i];
            if (i == 0) {
                clauseBuilder.summary().like(term);
                continue;
            }
            clauseBuilder.or().summary().like(term);
        }
        clauseBuilder.endsub();
        return clauseBuilder;
    }

    private void addCustomFieldClause(JqlClauseBuilder clauseBuilder, long vpOriginId) {
        clauseBuilder.and().customField(Long.valueOf(vpOriginId)).isNotEmpty();
    }

    private void addServiceDeskClause(JqlClauseBuilder clauseBuilder, Option<ServiceDesk> serviceDeskOption) {
        serviceDeskOption.foreach(sd -> clauseBuilder.and().project(new Long[]{sd.getProjectId()}));
    }
}

