/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.base;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResult;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.error.ErrorHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.ASCIIFoldingFilter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class GlobalRequestTypeSearchAlgorithm
implements RequestTypeSearchAlgorithm {
    private static final Logger log = LoggerFactory.getLogger(GlobalRequestTypeSearchAlgorithm.class);
    private static final Version LUCENE_VERSION = Version.LUCENE_33;
    private static final String SEARCH_FIELD_NAME = "searchOn";
    private final RequestTypeService requestTypeService;
    private final PortalService portalService;
    private final ErrorHelper errorHelper;

    @Autowired
    public GlobalRequestTypeSearchAlgorithm(RequestTypeService requestTypeService, PortalService portalService, ErrorHelper errorHelper) {
        this.requestTypeService = requestTypeService;
        this.portalService = portalService;
        this.errorHelper = errorHelper;
    }

    @Override
    public String getDescription() {
        return "Based on Lucene: lucenifies all existing request types, and matches the search query against the request type name and description";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery query) {
        Set<Document> docs = this.getAndLucenifyRequestTypes(user);
        if (docs.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)RequestTypeSearchResultListImpl.NO_RESULTS);
        }
        CustomAnalyzer customAnalyser = new CustomAnalyzer();
        Directory index = this.createLuceneIndex(docs, customAnalyser);
        IndexReader indexReader = null;
        try {
            indexReader = IndexReader.open((Directory)index);
            io.atlassian.fugue.Either<AnError, TopDocs> topDocsEither = this.search(query.getSearchText(), query.getLimit(), customAnalyser, indexReader);
            if (topDocsEither.isLeft()) {
                io.atlassian.fugue.Either either = io.atlassian.fugue.Either.left((Object)topDocsEither.left().get());
                return either;
            }
            TopDocs topDocs = (TopDocs)topDocsEither.right().get();
            ArrayList requestTypeSearchResults = Lists.newArrayList();
            for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
                Option<RequestTypeSearchResult> searchResultsOption = this.convertDocumentToRequestTypeSearchResult(user, scoreDoc, indexReader);
                if (!searchResultsOption.isDefined()) continue;
                RequestTypeSearchResult searchResult = (RequestTypeSearchResult)searchResultsOption.get();
                requestTypeSearchResults.add(searchResult);
            }
            Collections.sort(requestTypeSearchResults, new Comparator<RequestTypeSearchResult>(){

                @Override
                public int compare(RequestTypeSearchResult o1, RequestTypeSearchResult o2) {
                    return Float.compare(o1.getSearchScore(), o2.getSearchScore());
                }
            });
            RequestTypeSearchResultListImpl requestTypeSearchResultList = new RequestTypeSearchResultListImpl(requestTypeSearchResults);
            io.atlassian.fugue.Either either = io.atlassian.fugue.Either.right((Object)requestTypeSearchResultList);
            return either;
        }
        catch (IOException ex) {
            io.atlassian.fugue.Either either = this.errorHelper.errorIndexReader(ex);
            return either;
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException ex) {
                    log.error("Failed to close index reader: {}", (Throwable)ex);
                }
            }
        }
    }

    private Document convertRequestTypeToDocument(RequestType requestType) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("id", requestType.getId() + "", Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("parentPortalID", requestType.getPortalId() + "", Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("issueTypeId", requestType.getIssueTypeId() + "", Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("name", requestType.getName(), Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("description", requestType.getDescription(), Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field("icon", requestType.getIconId() + "", Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field(SEARCH_FIELD_NAME, requestType.getDescription() + " " + requestType.getName(), Field.Store.NO, Field.Index.ANALYZED));
        return doc;
    }

    private Option<RequestTypeSearchResult> convertDocumentToRequestTypeSearchResult(ApplicationUser user, ScoreDoc scoreDoc, IndexReader indexReader) {
        try {
            Document doc = indexReader.document(scoreDoc.doc);
            int portalId = Integer.parseInt(doc.get("parentPortalID"));
            io.atlassian.fugue.Either portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForId(user, (long)portalId));
            if (portalEither.isLeft()) {
                return Option.none();
            }
            Portal portal = (Portal)portalEither.right().get();
            String portalName = portal.getName();
            RequestTypeSearchResultImpl requestTypeSearchResult = new RequestTypeSearchResultImpl(Integer.parseInt(doc.get("id")), portalId, doc.get("name"), doc.get("description"), Long.parseLong(doc.get("issueTypeId")), Long.parseLong(doc.get("icon")), (Option<Float>)Option.some((Object)new Float(scoreDoc.score)), portalName);
            return Option.some((Object)requestTypeSearchResult);
        }
        catch (IOException | NumberFormatException ex) {
            return Option.none();
        }
    }

    private Set<Document> getAndLucenifyRequestTypes(ApplicationUser user) {
        RequestTypeQuery.Builder requestTypeQueryBuilder = this.requestTypeService.newQueryBuilder();
        RequestTypeQuery requestTypeQuery = requestTypeQueryBuilder.isValid(Boolean.valueOf(true)).build();
        io.atlassian.fugue.Either allRequestTypeEither = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, requestTypeQuery));
        if (allRequestTypeEither.isLeft()) {
            return Sets.newHashSet();
        }
        Iterable requestTypes = (Iterable)allRequestTypeEither.right().get();
        List rtDocs = Lists.transform((List)Lists.newArrayList((Iterable)requestTypes), this::convertRequestTypeToDocument);
        return Sets.newHashSet((Iterable)rtDocs);
    }

    private Directory createLuceneIndex(Set<Document> documents, Analyzer customAnalyser) {
        RAMDirectory idx = new RAMDirectory();
        IndexWriterConfig indexConfig = new IndexWriterConfig(LUCENE_VERSION, customAnalyser);
        indexConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try {
            IndexWriter indexWriter = new IndexWriter((Directory)idx, indexConfig);
            for (Document doc : documents) {
                indexWriter.addDocument(doc);
            }
            indexWriter.optimize();
            indexWriter.close();
            return idx;
        }
        catch (IOException ex) {
            return idx;
        }
    }

    private io.atlassian.fugue.Either<AnError, TopDocs> search(String searchString, Integer maxNumResults, Analyzer customAnalyser, IndexReader indexReader) {
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            Query query = new QueryParser(LUCENE_VERSION, searchString, customAnalyser).parse(this.createQueryText(searchString));
            TopDocs hits = searcher.search(query, maxNumResults.intValue());
            return io.atlassian.fugue.Either.right((Object)hits);
        }
        catch (IOException | ParseException ex) {
            return this.errorHelper.errorSearching((Exception)ex);
        }
    }

    private String createQueryText(String searchString) {
        String[] splits = QueryParser.escape((String)searchString).trim().split("\\s+");
        String query = "";
        for (String split : splits) {
            query = query + " searchOn:" + split;
        }
        return query;
    }

    private static class CustomAnalyzer
    extends Analyzer {
        private CustomAnalyzer() {
        }

        public TokenStream tokenStream(String s, Reader reader) {
            StandardTokenizer result = new StandardTokenizer(LUCENE_VERSION, reader);
            result = new StandardFilter(LUCENE_VERSION, (TokenStream)result);
            result = new LowerCaseFilter(LUCENE_VERSION, (TokenStream)result);
            result = new ASCIIFoldingFilter((TokenStream)result);
            result = new StopFilter(LUCENE_VERSION, (TokenStream)result, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
            result = new EdgeNGramTokenFilter((TokenStream)result, EdgeNGramTokenFilter.Side.FRONT, 1, 20);
            return result;
        }
    }
}

