/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestTypeServiceHelper {
    private static final int NUMBER_OF_REQUEST_TYPE_PER_PAGE = 100;
    private final RequestTypeService requestTypeService;

    @Autowired
    public RequestTypeServiceHelper(@Nonnull RequestTypeService requestTypeService) {
        this.requestTypeService = requestTypeService;
    }

    public Iterable<io.atlassian.fugue.Either<AnError, RequestType>> getAllValidRequestTypes(@Nonnull ApplicationUser user, @Nonnull Option<ServiceDesk> serviceDeskOption) {
        RequestTypeQuery.Builder requestTypeQueryBuilder = this.requestTypeService.newQueryBuilder().isValid(Boolean.valueOf(true)).filterHidden(Boolean.valueOf(true));
        serviceDeskOption.map(sd -> requestTypeQueryBuilder.serviceDesk(Integer.valueOf(sd.getId())));
        return this.getAllRequestTypes(user, requestTypeQueryBuilder.build());
    }

    private Iterable<io.atlassian.fugue.Either<AnError, RequestType>> getAllRequestTypes(@Nonnull ApplicationUser user, @Nonnull RequestTypeQuery requestTypeQuery) {
        return new RequestTypeIterable(user, requestTypeQuery);
    }

    private class RequestTypeIterator
    implements Iterator<io.atlassian.fugue.Either<AnError, RequestType>> {
        private final ApplicationUser user;
        private RequestTypeQuery query;
        private io.atlassian.fugue.Either<AnError, Iterator<RequestType>> iteratorEither;
        private boolean hasNextPage = true;
        private int startingIndex = 0;

        private RequestTypeIterator(@Nonnull ApplicationUser user, RequestTypeQuery query) {
            this.user = user;
            this.query = this.getQueryStartingFrom(query, this.startingIndex);
            this.updateResults();
        }

        @Override
        public boolean hasNext() {
            return (Boolean)this.iteratorEither.map(iterator -> iterator.hasNext() || this.hasNextPage).getOrElse((Object)false);
        }

        @Override
        public io.atlassian.fugue.Either<AnError, RequestType> next() {
            this.updateResultsIfNeeded();
            return this.iteratorEither.map(Iterator::next);
        }

        private void updateResultsIfNeeded() {
            this.iteratorEither.foreach(iterator -> {
                if (!iterator.hasNext() && this.hasNextPage) {
                    this.updateResults();
                }
            });
        }

        private void updateResults() {
            RequestTypeQuery newQuery = this.getQueryStartingFrom(this.query, this.startingIndex);
            io.atlassian.fugue.Either pagedResponseEither = StepsConverters.newerEither((Either)RequestTypeServiceHelper.this.requestTypeService.getRequestTypes(this.user, newQuery));
            this.iteratorEither = pagedResponseEither.map(pagedResponse -> {
                this.startingIndex += pagedResponse.size();
                this.hasNextPage = pagedResponse.hasNextPage();
                return pagedResponse.iterator();
            });
        }

        private RequestTypeQuery getQueryStartingFrom(RequestTypeQuery query, int startingIndex) {
            RequestTypeQuery.Builder builder = RequestTypeServiceHelper.this.requestTypeService.newQueryBuilder();
            query.issue().forEach(arg_0 -> ((RequestTypeQuery.Builder)builder).issue(arg_0));
            query.isValid().forEach(arg_0 -> ((RequestTypeQuery.Builder)builder).isValid(arg_0));
            query.getFilterHidden().foreach(arg_0 -> ((RequestTypeQuery.Builder)builder).filterHidden(arg_0));
            query.requestType().forEach(arg_0 -> ((RequestTypeQuery.Builder)builder).requestType(arg_0));
            query.serviceDesk().forEach(arg_0 -> ((RequestTypeQuery.Builder)builder).serviceDesk(arg_0));
            builder.pagedRequest((PagedRequest)new SimplePagedRequest(startingIndex, 100));
            return builder.build();
        }
    }

    private class RequestTypeIterable
    implements Iterable<io.atlassian.fugue.Either<AnError, RequestType>> {
        private final ApplicationUser user;
        private final RequestTypeQuery query;

        private RequestTypeIterable(@Nonnull ApplicationUser user, RequestTypeQuery query) {
            this.user = user;
            this.query = query;
        }

        @Override
        public Iterator<io.atlassian.fugue.Either<AnError, RequestType>> iterator() {
            return new RequestTypeIterator(this.user, this.query);
        }
    }
}

