/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.search.SearchFeatureFlags;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchService;
import com.atlassian.servicedesk.plugins.search.error.ErrorHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithmFactory;
import com.atlassian.util.concurrent.Assertions;
import io.atlassian.fugue.Either;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestTypeSearchServiceImpl
implements RequestTypeSearchService {
    private final RequestTypeSearchAlgorithmFactory requestTypeSearchAlgorithmFactory;
    private final FeatureManager featureManager;
    private final ErrorHelper errorHelper;

    @Autowired
    public RequestTypeSearchServiceImpl(RequestTypeSearchAlgorithmFactory requestTypeSearchAlgorithmFactory, FeatureManager featureManager, ErrorHelper errorHelper) {
        this.requestTypeSearchAlgorithmFactory = requestTypeSearchAlgorithmFactory;
        this.featureManager = featureManager;
        this.errorHelper = errorHelper;
    }

    public Either<AnError, RequestTypeSearchResultList> searchRequestTypes(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery requestTypeSearchQuery) {
        Assertions.notNull((String)"user", (Object)user);
        Assertions.notNull((String)"requestTypeSearchQuery", (Object)requestTypeSearchQuery);
        if (StringUtils.isBlank((String)requestTypeSearchQuery.getSearchText())) {
            return this.errorHelper.emptyQueryError();
        }
        RequestTypeSearchAlgorithm requestTypeSearchAlgorithm = this.featureManager.isEnabled(SearchFeatureFlags.SD_EXP_ALGORITHM_DEFAULT_ONE) ? this.requestTypeSearchAlgorithmFactory.getSummaryDescriptionJqlAlgorithm() : (this.featureManager.isEnabled(SearchFeatureFlags.SD_EXP_ALGORITHM_DEFAULT_TWO) ? this.requestTypeSearchAlgorithmFactory.getGlobalRequestTypeAlgorithm() : this.requestTypeSearchAlgorithmFactory.getComposedAlgorithm());
        return requestTypeSearchAlgorithm.search(user, requestTypeSearchQuery);
    }
}

