/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.error;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErrorHelper {
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ErrorHelper(ErrorResultHelper errorResultHelper) {
        this.errorResultHelper = errorResultHelper;
    }

    public <T> io.atlassian.fugue.Either<AnError, T> emptyQueryError() {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.search.query.must.not.by.empty", new Object[0]));
    }

    public <T> io.atlassian.fugue.Either<AnError, T> invalidResultLimit(int resultLimit) {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.BAD_REQUEST, "sd.search.result.limit.must.not.be.less.than.zero", new Object[0]));
    }

    public <T> io.atlassian.fugue.Either<AnError, T> errorIndexReader(IOException ex) {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "sd.search.failed.io.index.reader", new Object[]{ex}));
    }

    public <T> io.atlassian.fugue.Either<AnError, T> errorSearching(Exception ex) {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.INTERNAL_SERVER_ERROR, "sd.search.failed.searching", new Object[]{ex}));
    }

    @VisibleForTesting
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> algorithmNotFound(String algorithmId) {
        return StepsConverters.newerEither((Either)this.errorResultHelper.error(HttpStatusCode.NOT_FOUND, "sd.search.algorithm.not.found", new Object[]{algorithmId}));
    }
}

