/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.querydsl.Tables;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.querydsl.kb.AbstractQKbEventAggregate;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.querydsl.kb.KbAggregateTables;
import com.atlassian.servicedesk.plugins.reports.internal.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.reports.internal.visiblefortesting.ReportsDaoBackdoor;
import com.atlassian.servicedesk.plugins.reports.internal.visiblefortesting.response.KBArticleAggregateForTests;
import com.atlassian.servicedesk.plugins.reports.internal.visiblefortesting.response.StatsEventForTests;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.querydsl.core.Tuple;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class ReportsDaoBackdoorImpl
implements ReportsDaoBackdoor {
    private final DatabaseAccessor databaseAccessor;
    private final QueryDslDaoHelper queryDslDaoHelper;

    @Autowired
    public ReportsDaoBackdoorImpl(DatabaseAccessor databaseAccessor, QueryDslDaoHelper queryDslDaoHelper) {
        this.databaseAccessor = databaseAccessor;
        this.queryDslDaoHelper = queryDslDaoHelper;
    }

    @Override
    public Either<AnError, List<StatsEventForTests>> getAllStatsEvents() {
        return (Either)this.databaseAccessor.run(databaseConnection -> {
            List tuples = ((SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(this.combine(Tables.STATS_EVENT.all(), Tables.STATS_EVENT_PARAM.all())).from((Expression)Tables.STATS_EVENT)).innerJoin((EntityPath)Tables.STATS_EVENT_PARAM)).on((Predicate)Tables.STATS_EVENT.ID.eq(Tables.STATS_EVENT_PARAM.STATS_EVENT_ID))).fetch();
            HashMap statsEvents = Maps.newHashMap();
            for (Tuple tuple : tuples) {
                Long id = (Long)tuple.get(Tables.STATS_EVENT.ID);
                if (!statsEvents.containsKey(id)) {
                    String key = (String)tuple.get((Expression)Tables.STATS_EVENT.EVENT_KEY);
                    Long time = (Long)tuple.get(Tables.STATS_EVENT.EVENT_TIME);
                    StatsEventForTests statsEvent = new StatsEventForTests(time, key, Maps.newHashMap());
                    statsEvents.put(id, statsEvent);
                }
                StatsEventForTests statsEvent = (StatsEventForTests)statsEvents.get(id);
                String key = (String)tuple.get((Expression)Tables.STATS_EVENT_PARAM.PARAM_NAME);
                String value = (String)tuple.get((Expression)Tables.STATS_EVENT_PARAM.PARAM_VALUE);
                statsEvent.getEventParams().put(key, value);
            }
            return Either.right((Object)Lists.newArrayList(statsEvents.values()));
        });
    }

    @Override
    public Either<AnError, List<StatsEventForTests>> resetAndAddStatsEvents(List<StatsEventForTests> statsEvents) {
        return (Either)this.databaseAccessor.runInTransaction(connection -> {
            connection.delete((RelationalPath)Tables.STATS_EVENT_PARAM).execute();
            connection.delete((RelationalPath)Tables.STATS_EVENT).execute();
            statsEvents.forEach(statsEvent -> {
                long insertStatsEvent = this.insertStatsEvent((DatabaseConnection)connection, (StatsEventForTests)statsEvent);
                this.insertStatsEventParams((DatabaseConnection)connection, insertStatsEvent, (StatsEventForTests)statsEvent);
            });
            return Either.right((Object)statsEvents);
        });
    }

    @Override
    public Either<AnError, List<KBArticleAggregateForTests>> getAllKbHelpfulAggrEntries() {
        return this.getAllFromTable(KbAggregateTables.KB_HELPFUL_AGGREGATE, tuple -> new KBArticleAggregateForTests((Long)tuple.get(KbAggregateTables.KB_HELPFUL_AGGREGATE.SERVICE_DESK_ID), (Long)tuple.get(KbAggregateTables.KB_HELPFUL_AGGREGATE.START_TIME), (Long)tuple.get(KbAggregateTables.KB_HELPFUL_AGGREGATE.COUNT)));
    }

    @Override
    public Either<AnError, List<KBArticleAggregateForTests>> getAllKbViewAggrEntries() {
        return this.getAllFromTable(KbAggregateTables.KB_VIEW_AGGREGATE, tuple -> new KBArticleAggregateForTests((Long)tuple.get(KbAggregateTables.KB_VIEW_AGGREGATE.SERVICE_DESK_ID), (Long)tuple.get(KbAggregateTables.KB_VIEW_AGGREGATE.START_TIME), (Long)tuple.get(KbAggregateTables.KB_VIEW_AGGREGATE.COUNT)));
    }

    @Override
    public Either<AnError, Long> resetAndAddKbHelpfulAggregateRow(List<KBArticleAggregateForTests> kbArticleAggregates) {
        return this.resetAndAddKbArticleAggregateRow(KbAggregateTables.KB_HELPFUL_AGGREGATE, kbArticleAggregates);
    }

    @Override
    public Either<AnError, Long> resetAndAddKbViewAggregateRow(List<KBArticleAggregateForTests> kbArticleAggregates) {
        return this.resetAndAddKbArticleAggregateRow(KbAggregateTables.KB_VIEW_AGGREGATE, kbArticleAggregates);
    }

    private long insertStatsEventParams(DatabaseConnection databaseConnection, Long statsEventId, StatsEventForTests statsEvent) {
        Set<Map.Entry<String, Object>> parameters = statsEvent.getEventParams().entrySet();
        if (parameters.isEmpty()) {
            return 0L;
        }
        SQLInsertClause batchInsertStatement = databaseConnection.insert((RelationalPath)Tables.STATS_EVENT_PARAM);
        for (Map.Entry<String, Object> entry : parameters) {
            batchInsertStatement.set(Tables.STATS_EVENT_PARAM.STATS_EVENT_ID, (Object)statsEventId);
            batchInsertStatement.set((Path)Tables.STATS_EVENT_PARAM.PARAM_NAME, (Object)entry.getKey());
            batchInsertStatement.set((Path)Tables.STATS_EVENT_PARAM.PARAM_VALUE, (Object)entry.getValue().toString());
            batchInsertStatement.addBatch();
        }
        return this.queryDslDaoHelper.executeMultipleRowUpdates((DMLClause)batchInsertStatement, parameters.size());
    }

    private long insertStatsEvent(DatabaseConnection databaseConnection, StatsEventForTests statsEvent) {
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.STATS_EVENT).set((Path)Tables.STATS_EVENT.EVENT_KEY, (Object)statsEvent.getEventKey()).set(Tables.STATS_EVENT.EVENT_TIME, (Object)statsEvent.getEventTime());
        return this.queryDslDaoHelper.executeSingleRowInsertReturningId(databaseConnection, insertClause);
    }

    private Either<AnError, Long> resetAndAddKbArticleAggregateRow(AbstractQKbEventAggregate<?> abstractQKbEventAggregate, List<KBArticleAggregateForTests> kbArticleAggregates) {
        Long numberOfRowsInserted = (Long)this.databaseAccessor.runInTransaction(connection -> {
            connection.delete((RelationalPath)abstractQKbEventAggregate).execute();
            SQLInsertClause insertClause = connection.insert((RelationalPath)abstractQKbEventAggregate);
            kbArticleAggregates.forEach(aggregate -> {
                insertClause.set(abstractQKbEventAggregate.SERVICE_DESK_ID, (Object)aggregate.getServiceDeskId());
                insertClause.set(abstractQKbEventAggregate.START_TIME, (Object)aggregate.getStartTime());
                insertClause.set(abstractQKbEventAggregate.COUNT, (Object)aggregate.getCount());
                insertClause.addBatch();
            });
            return this.queryDslDaoHelper.executeMultipleRowUpdates((DMLClause)insertClause, kbArticleAggregates.size());
        });
        return Either.right((Object)numberOfRowsInserted);
    }

    private <T> Either<AnError, List<T>> getAllFromTable(EnhancedRelationalPathBase table, Function<Tuple, T> tupleToResponseObjectMapper) {
        return (Either)this.databaseAccessor.run(databaseConnection -> {
            List tuples = ((SQLQuery)databaseConnection.select((Expression[])table.all()).from((Expression)table)).fetch();
            List entries = Lists.transform((List)tuples, arg_0 -> ((Function)tupleToResponseObjectMapper).apply(arg_0));
            return Either.right((Object)entries);
        });
    }

    private Path<?>[] combine(Path<?>[] pathArray1, Path<?>[] pathArray2) {
        Path[] combined = new Path[pathArray1.length + pathArray2.length];
        System.arraycopy(pathArray1, 0, combined, 0, pathArray1.length);
        System.arraycopy(pathArray2, 0, combined, pathArray1.length, pathArray2.length);
        return combined;
    }
}

