/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.timeutil;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.TimeBreakdown;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class Timescale {
    private final TimeBreakdown timeBreakdown;
    private final DateTime endTime;
    private final DateTime startTime;
    private final List<Interval> timeIntervals;

    private Timescale(Period totalTimePeriod, TimeBreakdown timeBreakdown, DateTime endTime) {
        this.timeBreakdown = timeBreakdown;
        this.endTime = endTime;
        this.startTime = timeBreakdown.flattenDateTime(endTime.minus((ReadablePeriod)totalTimePeriod)).plus((ReadablePeriod)timeBreakdown.getPeriod());
        this.timeIntervals = this.calculateTimeIntervals();
    }

    public static io.atlassian.fugue.Either<AnError, Timescale> createTimescale(Period totalTimePeriod, TimeBreakdown timeBreakdown, long endTimeMillis, DateTimeZone userTimeZone, ErrorResultHelper errorResultHelper) {
        Duration timeBreakdownDuration;
        DateTime endTime = new DateTime(endTimeMillis, userTimeZone);
        Duration totalTimePeriodDuration = totalTimePeriod.toDurationTo((ReadableInstant)endTime);
        if (totalTimePeriodDuration.compareTo((ReadableDuration)(timeBreakdownDuration = timeBreakdown.getPeriod().toDurationTo((ReadableInstant)endTime))) < 0) {
            return StepsConverters.newerEither((Either)errorResultHelper.badRequest400("sd.project.reports.timescale.invalid.period.length", new Object[0]).toEither());
        }
        return io.atlassian.fugue.Either.right((Object)new Timescale(totalTimePeriod, timeBreakdown, endTime));
    }

    public List<Interval> getTimeIntervals() {
        return this.timeIntervals;
    }

    public Option<Integer> getBucketIndex(long dateTimeMillis) {
        DateTime dateTime = new DateTime(dateTimeMillis, DateTimeZone.UTC);
        if (dateTime.isBefore((ReadableInstant)this.startTime) || dateTime.isAfter((ReadableInstant)this.endTime)) {
            return Option.none();
        }
        int timeUnitsBetween = this.timeBreakdown.getUnitsBetween(this.startTime, dateTime);
        if (timeUnitsBetween >= this.timeIntervals.size()) {
            return Option.none();
        }
        return Option.some((Object)timeUnitsBetween);
    }

    public Option<Long> getEndTimeAsMillis() {
        return Option.option((Object)this.endTime.getMillis());
    }

    public Option<Long> getStartTimeAsMillis() {
        return Option.option((Object)this.startTime.getMillis());
    }

    private List<Interval> calculateTimeIntervals() {
        Period breakdownPeriod = this.timeBreakdown.getPeriod();
        ImmutableList.Builder result = ImmutableList.builder();
        DateTime intervalStart = this.startTime;
        DateTime intervalEnd = intervalStart.plus((ReadablePeriod)breakdownPeriod);
        while (intervalEnd.isBefore((ReadableInstant)this.endTime)) {
            result.add((Object)new Interval((ReadableInstant)intervalStart, (ReadableInstant)intervalEnd));
            intervalStart = intervalEnd;
            intervalEnd = intervalEnd.plus((ReadablePeriod)breakdownPeriod);
        }
        result.add((Object)new Interval((ReadableInstant)intervalStart, (ReadableInstant)this.endTime));
        return result.build();
    }

    public TimeBreakdown getTimeBreakdown() {
        return this.timeBreakdown;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }
}

