/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.issue;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.requesttype.customfield.RequestTypeCustomFieldService;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CountCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.model.YAxisType;
import com.atlassian.servicedesk.plugins.reports.internal.series.SeriesData;
import com.atlassian.servicedesk.plugins.reports.internal.series.issue.RequestTypeSearchDataCallback;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Either;
import java.util.Date;
import org.apache.lucene.search.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestCreatedSeriesManager {
    private static final Logger log = LoggerFactory.getLogger(RequestCreatedSeriesManager.class);
    private final SearchProvider searchProvider;
    private final RequestTypeCustomFieldService requestTypeCustomFieldService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public RequestCreatedSeriesManager(SearchProvider searchProvider, RequestTypeCustomFieldService requestTypeCustomFieldService, ErrorResultHelper errorResultHelper) {
        this.searchProvider = searchProvider;
        this.requestTypeCustomFieldService = requestTypeCustomFieldService;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, SeriesData> getSeriesData(ServiceDesk serviceDesk, Timescale timescale) {
        return (Either)Steps.begin(timescale.getStartTimeAsMillis()).then(firstInterval -> timescale.getEndTimeAsMillis()).yield((startTime, endTime) -> this.buildJql(serviceDesk, (Long)startTime, (Long)endTime)).fold(() -> {
            log.warn("Returning empty series as timescale has zero intervals, this is unexpected");
            return Either.right((Object)SeriesData.EMPTY_COUNT_DATA);
        }, query -> this.searchWithQuery((Query)query, timescale));
    }

    private Query buildJql(ServiceDesk serviceDesk, Long startTime, Long endTime) {
        Long vpOriginId = this.requestTypeCustomFieldService.getRequestTypeCustomField().getCustomFieldId();
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        return jqlQueryBuilder.where().project(new Long[]{serviceDesk.getProjectId()}).and().createdBetween(new Date(startTime), new Date(endTime + 60000L)).and().customField(vpOriginId).isNotEmpty().endWhere().buildQuery();
    }

    private Either<AnError, SeriesData> searchWithQuery(Query query, Timescale timescale) {
        CountCollector countCollector = new CountCollector(timescale);
        try {
            this.searchProvider.searchAndSortOverrideSecurity(query, null, (Collector)new RequestTypeSearchDataCallback(countCollector), PagerFilter.getUnlimitedFilter());
            DataCollectorResult<Long> data = countCollector.data();
            return Either.right((Object)new SeriesData(data, YAxisType.COUNT, (Number)data.getSeriesSummaryValue()));
        }
        catch (SearchException e) {
            log.warn("There was an error searching for issues with query {0}", (Object)query, (Object)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.project.reports.issue.search.error", new Object[0]).build());
        }
    }
}

