/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.ReportDrillDownKbArticleResponse;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReportDrillDownKbArticleResponseHandler
extends BaseAppLinkResponseHandler<Map<String, ReportDrillDownKbArticleResponse>> {
    private static final Logger logger = LoggerFactory.getLogger(ReportDrillDownKbArticleResponseHandler.class);

    ReportDrillDownKbArticleResponseHandler(ErrorResultHelper errorResultHelper, ApplicationLinkErrors applicationLinkErrors) {
        super(applicationLinkErrors, errorResultHelper);
    }

    public Either<AnError, Map<String, ReportDrillDownKbArticleResponse>> onCredentialError(String responseBody) {
        logger.warn("Credentials rejected by Knowledge base server");
        return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK_CONFIGURATION());
    }

    public Either<AnError, Map<String, ReportDrillDownKbArticleResponse>> onError(String responseBody, int statusCode) {
        return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
    }

    public Either<AnError, Map<String, ReportDrillDownKbArticleResponse>> onSuccess(String responseBody) {
        Option jsonObjectOption = this.toJsonObject(responseBody);
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = (JsonNode)jsonObjectOption.getOrElse((Object)objectMapper.createObjectNode());
        HashMap<String, ReportDrillDownKbArticleResponse> results = new HashMap<String, ReportDrillDownKbArticleResponse>();
        if (jsonNode.get("results") != null) {
            try {
                for (JsonNode result : jsonNode.get("results")) {
                    JsonNode createdBy = result.get("history").get("createdBy");
                    String pageId = (String)this.getStringValue(result.get("id")).getOrNull();
                    String pageTitle = (String)this.getStringValue(result.get("title")).getOrNull();
                    String createdByUserName = (String)this.getStringValue(createdBy.get("displayName")).getOrNull();
                    String createdByUserImage = (String)this.getStringValue(createdBy.get("profilePicture").get("path")).getOrNull();
                    String lastUpdated = (String)this.getStringValue(result.get("history").get("lastUpdated").get("when")).getOrNull();
                    if (pageId == null || pageTitle == null || createdByUserImage == null || createdByUserName == null || lastUpdated == null) continue;
                    results.put(pageId, new ReportDrillDownKbArticleResponse(pageId, pageTitle, createdByUserName, createdByUserImage, lastUpdated));
                }
            }
            catch (NullPointerException e) {
                logger.debug("Response body from Confluence when fetching data for drill down was not as expected: %s \n %s", (Object)e.getMessage(), (Object)responseBody);
            }
        }
        return Either.right(results);
    }

    private Option<String> getStringValue(JsonNode jsonNode) {
        return Option.option((Object)jsonNode).map(JsonNode::getTextValue);
    }
}

