/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedReportDrillDownManager;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedReportDrillDownService;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class PredefinedReportDrillDownServiceImpl
implements PredefinedReportDrillDownService {
    private ServiceDeskPermissionService serviceDeskPermissionService;
    private ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private PredefinedReportDrillDownManager predefinedReportDrillDownManager;
    private ErrorResultHelper errorResultHelper;

    @Autowired
    public PredefinedReportDrillDownServiceImpl(ServiceDeskPermissionService serviceDeskPermissionService, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, PredefinedReportDrillDownManager predefinedReportDrillDownManager, ErrorResultHelper errorResultHelper) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.predefinedReportDrillDownManager = predefinedReportDrillDownManager;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<ReportDrillDownItem>> getDrillDownArticlesForSeries(ApplicationUser applicationUser, Project project, ServiceDesk serviceDesk, String seriesId, Timescale timescale, LimitedPagedRequest pagedRequest) {
        return Steps.begin(this.checkAgentPermission(applicationUser, serviceDesk)).then(agent -> this.confluenceKnowledgeBaseService.getKBLink(agent, project)).then((agent, kbLink) -> this.predefinedReportDrillDownManager.getDrillDownForPredefinedSeries(seriesId, (Option<ConfluenceKnowledgeBaseLink>)Option.option((Object)kbLink), pagedRequest)).yield((agent, kbLink, results) -> results);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Long> getTotalNumberOfDrillDownItemsForSeries(ApplicationUser user, ServiceDesk serviceDesk, String seriesId) {
        return Steps.begin(this.checkAgentPermission(user, serviceDesk)).then(agent -> this.predefinedReportDrillDownManager.getTotalNumberOfArticles(seriesId)).yield((agent, total) -> total);
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> checkAgentPermission(ApplicationUser applicationUser, ServiceDesk serviceDesk) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(applicationUser, serviceDesk)).flatMap(isPermitted -> Eithers.cond((boolean)isPermitted, (Object)this.errorResultHelper.forbidden403("sd.project.reports.not.permitted.view.report", new Object[0]).build(), (Object)applicationUser));
    }
}

