/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkManager;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownFieldView;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.ArticleWithDrillDownData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedKbReportDrillDownItemImpl;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedReportDrillDownManager;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.ReportDrillDownKbArticleResponse;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.ReportDrillDownKbArticleResponseHandler;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class PredefinedReportDrillDownManagerImpl
implements PredefinedReportDrillDownManager {
    private static final String SEARCH_URL_BASE = "/rest/api/content/search?cql=%s&limit=50&expand=history.lastUpdated";
    private static final String CQL_STRING = "type=page and space='%s' and id in (%s)";
    private final ApplicationProperties applicationProperties;
    private final ErrorResultHelper errorResultHelper;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final ServiceDeskAppLinkManager serviceDeskAppLinkManager;

    @Autowired
    public PredefinedReportDrillDownManagerImpl(ApplicationProperties applicationProperties, ErrorResultHelper errorResultHelper, ApplicationLinkErrors applicationLinkErrors, ServiceDeskAppLinkManager serviceDeskAppLinkManager) {
        this.applicationProperties = applicationProperties;
        this.errorResultHelper = errorResultHelper;
        this.applicationLinkErrors = applicationLinkErrors;
        this.serviceDeskAppLinkManager = serviceDeskAppLinkManager;
    }

    @Override
    public Either<AnError, List<ReportDrillDownItem>> getDrillDownForPredefinedSeries(String seriesId, Option<ConfluenceKnowledgeBaseLink> kbLink, LimitedPagedRequest pagedRequest) {
        if (seriesId.equals(PredefinedReportSeries.NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES.getId()) || seriesId.equals(PredefinedReportSeries.NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES.getId())) {
            List<ArticleWithDrillDownData> allArticles = this.dummyArticlesForViewsSeries();
            List<ArticleWithDrillDownData> requestedPage = allArticles.subList(pagedRequest.getStart(), this.getEndOfPageIndex(allArticles, pagedRequest));
            return this.augmentAndTransformResults(seriesId, (ConfluenceKnowledgeBaseLink)kbLink.get(), requestedPage);
        }
        return Either.left((Object)this.errorResultHelper.builder("", new Object[0]).httpStatusCode(501).build());
    }

    private int getEndOfPageIndex(List<ArticleWithDrillDownData> allArticles, LimitedPagedRequest pagedRequest) {
        int endOfPageIndex = pagedRequest.getStart() + pagedRequest.getLimit();
        if (endOfPageIndex > allArticles.size()) {
            endOfPageIndex = allArticles.size();
        }
        return endOfPageIndex;
    }

    @Override
    public Either<AnError, Long> getTotalNumberOfArticles(String seriesId) {
        if (seriesId.equals(PredefinedReportSeries.NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES.getId()) || seriesId.equals(PredefinedReportSeries.NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES.getId())) {
            return Either.right((Object)this.dummyArticlesForViewsSeries().size());
        }
        return Either.left((Object)this.errorResultHelper.builder("", new Object[0]).httpStatusCode(501).build());
    }

    private List<ArticleWithDrillDownData> dummyArticlesForViewsSeries() {
        ArrayList<String> ids = new ArrayList<String>(Arrays.asList("2686981", "2686986", "2686984", "2686989", "2686991", "2686996", "2686992", "2686993", "2686995", "2686994", "2687002", "2687001", "2686997", "2687000", "2686998", "2686999", "2687003", "2687004", "2687005", "2687007", "2687006", "2687008", "2687009", "2687010", "2687013", "2687012", "2687014", "2687011", "2687015", "2687017", "2687016", "2687018", "2687020", "2687019", "2687021", "2687024", "2687023", "2687022", "2687025", "2687026", "2687027", "2687029", "2687028", "2687032", "2687030", "2687031", "2687034", "2687036", "2687035", "2687033"));
        ArrayList<ArticleWithDrillDownData> articles = new ArrayList<ArticleWithDrillDownData>();
        for (String id : ids) {
            articles.add(new ArticleWithDrillDownData(id, "1", "1", "Title", ""));
        }
        return articles;
    }

    @VisibleForTesting
    Either<AnError, String> buildCqlQueryUrl(String spaceKey, Set<String> pageIds) {
        String pageQuery;
        String pages = StringUtils.join(pageIds, (String)",");
        try {
            pageQuery = URLEncoder.encode(String.format(CQL_STRING, spaceKey, pages), this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return Either.left((Object)this.errorResultHelper.builder("sd.knowledge.base.applink.url.parameter.encoding.error", new Object[0]).httpStatusCode(412).build());
        }
        return Either.right((Object)String.format(SEARCH_URL_BASE, pageQuery));
    }

    private Either<AnError, List<ReportDrillDownItem>> augmentAndTransformResults(String seriesId, ConfluenceKnowledgeBaseLink kbLink, List<ArticleWithDrillDownData> articleList) {
        Map articles = articleList.stream().collect(Collectors.toMap(ArticleWithDrillDownData::getPageId, Function.identity()));
        return Steps.begin(this.buildCqlQueryUrl(kbLink.getSpaceKey(), articles.keySet())).then(url -> this.serviceDeskAppLinkManager.makeGetRequest(kbLink.getApplicationId(), url, (BaseAppLinkResponseHandler)new ReportDrillDownKbArticleResponseHandler(this.errorResultHelper, this.applicationLinkErrors))).then((url, responses) -> this.transformToDrillDownData(seriesId, articles, (Map<String, ReportDrillDownKbArticleResponse>)responses)).yield((url, responses, drillDownRows) -> drillDownRows);
    }

    @VisibleForTesting
    Either<AnError, List<ReportDrillDownItem>> transformToDrillDownData(String seriesId, Map<String, ArticleWithDrillDownData> articles, Map<String, ReportDrillDownKbArticleResponse> responses) {
        ArrayList drillDownKbArticles = new ArrayList();
        articles.forEach((pageId, article) -> {
            ReportDrillDownKbArticleResponse response = (ReportDrillDownKbArticleResponse)responses.get(pageId);
            if (response == null) {
                drillDownKbArticles.add(new PredefinedKbReportDrillDownItemImpl(seriesId, this.buildFieldView(article.getPageTitle()), this.buildFieldView(article.getViews()), this.buildFieldView(article.getHelpfulVotes()), this.buildFieldView(""), this.buildFieldView("")));
            } else {
                drillDownKbArticles.add(new PredefinedKbReportDrillDownItemImpl(seriesId, this.buildFieldView(response.getPageTitle()), this.buildFieldView(article.getViews()), this.buildFieldView(article.getHelpfulVotes()), this.buildFieldView(response.getCreatedByName()), this.buildFieldView(response.getLastModified())));
            }
        });
        return Either.right(drillDownKbArticles);
    }

    private Option<DrillDownFieldView> buildFieldView(String field) {
        return Option.some((Object)new DrillDownFieldView(field, ""));
    }
}

