/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.issue;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackInternalService;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.CollectedIssue;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.issue.ReportDrillDownIssue;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.issue.ReportDrillDownIssueService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportDrillDownIssueServiceImpl
implements ReportDrillDownIssueService {
    private IssueManager issueManager;
    private RequestTypeService requestTypeService;
    private SlaInformationService slaInformationService;
    private RequestFeedbackInternalService requestFeedbackInternalService;
    private ErrorResultHelper errorResultHelper;
    private ServiceDeskPermissionService serviceDeskPermissionService;
    private FieldManager fieldManager;
    private VpOriginCustomFieldService vpOriginCustomFieldService;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private RequestFeedbackCFManager requestFeedbackCFManager;
    private SlaDurationFormatter slaDurationFormatter;

    @Autowired
    public ReportDrillDownIssueServiceImpl(IssueManager issueManager, RequestTypeService requestTypeService, SlaInformationService slaInformationService, RequestFeedbackInternalService requestFeedbackInternalService, ErrorResultHelper errorResultHelper, ServiceDeskPermissionService serviceDeskPermissionService, FieldManager fieldManager, VpOriginCustomFieldService vpOriginCustomFieldService, FieldScreenRendererFactory fieldScreenRendererFactory, RequestFeedbackCFManager requestFeedbackCFManager, SlaDurationFormatter slaDurationFormatter) {
        this.issueManager = issueManager;
        this.requestTypeService = requestTypeService;
        this.slaInformationService = slaInformationService;
        this.requestFeedbackInternalService = requestFeedbackInternalService;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.fieldManager = fieldManager;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.slaDurationFormatter = slaDurationFormatter;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<ReportDrillDownIssue>> getDrillDownIssuesForSeries(@Nonnull ApplicationUser applicationUser, @Nonnull ServiceDesk serviceDesk, @Nonnull Set<CollectedIssue> collectedIssues, @Nonnull SeriesDataTypeKeys seriesType, @Nonnull Option<TimeMetric> timeMetric) {
        io.atlassian.fugue.Either<AnError, ApplicationUser> passedUserCheck = this.checkUser(applicationUser, serviceDesk);
        if (passedUserCheck.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)passedUserCheck.left().get());
        }
        if (collectedIssues.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)ImmutableList.of());
        }
        ImmutableList.Builder drillDownRawDataIssues = ImmutableList.builder();
        for (Iterable partitionedCollectedIssues : Iterables.partition(collectedIssues, (int)100)) {
            ArrayList partitionedCollectedIssueList = Lists.newArrayList((Iterable)partitionedCollectedIssues);
            List issues = this.issueManager.getIssueObjects((Collection)partitionedCollectedIssueList.stream().map(CollectedIssue::getIssueId).collect(Collectors.toList()));
            for (Issue issue : issues) {
                Steps.begin((Option)Option.option((Object)issue)).then(nonNullIssue -> Option.fromOptional(partitionedCollectedIssueList.stream().filter(collectedIssue -> nonNullIssue.getId().equals(collectedIssue.getIssueId())).findFirst())).yield((nonNullIssue, collectedIssue) -> {
                    ReportDrillDownIssue reportDrillDownExportIssue = new ReportDrillDownIssue(issue, (CollectedIssue)collectedIssue, seriesType, applicationUser, timeMetric, this.slaDurationFormatter, this.requestTypeService, this.requestFeedbackInternalService, this.slaInformationService, this.fieldScreenRendererFactory, this.fieldManager, this.vpOriginCustomFieldService, this.requestFeedbackCFManager);
                    drillDownRawDataIssues.add((Object)reportDrillDownExportIssue);
                    return Unit.UNIT;
                });
            }
        }
        return io.atlassian.fugue.Either.right((Object)drillDownRawDataIssues.build());
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> checkUser(ApplicationUser user, ServiceDesk serviceDesk) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk)).flatMap(isPermitted -> Eithers.cond((boolean)isPermitted, (Object)this.errorResultHelper.forbidden403("sd.project.reports.not.permitted.view.report", new Object[0]).build(), (Object)user));
    }
}

