/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.issue;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.FieldException;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.api.sla.info.SlaInformation;
import com.atlassian.servicedesk.api.sla.info.SlaInformationCompletedCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationOngoingCycle;
import com.atlassian.servicedesk.api.sla.info.SlaInformationQuery;
import com.atlassian.servicedesk.api.sla.info.SlaInformationService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.api.util.paging.PagedResponse;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.feedback.Feedback;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackInternalService;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.CollectedIssue;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownFieldView;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ReportDrillDownIssue
implements ReportDrillDownItem {
    private static final String CUSTOM_FIELD_ID_PREFIX = "customfield_";
    private static final String ELAPSED_TIME_CSS_CLASS = "elapsedTime";
    private final Issue issue;
    private final CollectedIssue collectedIssue;
    private final SeriesDataTypeKeys seriesType;
    private final io.atlassian.fugue.Option<TimeMetric> timeMetricsOption;
    private final SlaDurationFormatter slaDurationFormatter;
    private final RequestTypeService requestTypeService;
    private final RequestFeedbackInternalService requestFeedbackInternalService;
    private final SlaInformationService slaInformationService;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final FieldManager fieldManager;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final ApplicationUser user;

    ReportDrillDownIssue(Issue issue, CollectedIssue collectedIssue, SeriesDataTypeKeys seriesType, ApplicationUser user, io.atlassian.fugue.Option<TimeMetric> timeMetricsOption, SlaDurationFormatter slaDurationFormatter, RequestTypeService requestTypeService, RequestFeedbackInternalService requestFeedbackInternalService, SlaInformationService slaInformationService, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, VpOriginCustomFieldService vpOriginCustomFieldService, RequestFeedbackCFManager requestFeedbackCFManager) {
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.fieldManager = fieldManager;
        this.issue = issue;
        this.collectedIssue = collectedIssue;
        this.seriesType = seriesType;
        this.timeMetricsOption = timeMetricsOption;
        this.slaDurationFormatter = slaDurationFormatter;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.user = user;
        this.requestTypeService = requestTypeService;
        this.requestFeedbackInternalService = requestFeedbackInternalService;
        this.slaInformationService = slaInformationService;
    }

    @Override
    public List<DrillDownFieldView> toDrillDownFieldView() {
        Map<String, NavigableField> allAvailableFields = this.getAllAvailableFields();
        String requestTypeCustomId = this.vpOriginCustomFieldService.getVpOriginCustomField().getId();
        ImmutableList.Builder row = ImmutableList.builder();
        row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "issuekey", allAvailableFields)));
        row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "summary", allAvailableFields)));
        row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "reporter", allAvailableFields)));
        row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "assignee", allAvailableFields)));
        row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, requestTypeCustomId, allAvailableFields)));
        if (SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "status", allAvailableFields)));
        } else if (SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, "resolution", allAvailableFields)));
        } else if (SeriesDataTypeKeys.AVERAGE_RATING_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            io.atlassian.fugue.Option createRequestFeedbackCF = this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF();
            createRequestFeedbackCF.forEach(customField -> row.add((Object)DrillDownFieldView.getFieldView(this.getFieldViewForId(this.issue, customField.getId(), allAvailableFields))));
        } else if (SeriesDataTypeKeys.SLA_BREACHED_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView((io.atlassian.fugue.Option<DrillDownFieldView>)this.timeMetricsOption.flatMap(timeMetric -> this.getFieldViewForId(this.issue, CUSTOM_FIELD_ID_PREFIX + timeMetric.getCustomFieldId(), allAvailableFields))));
        } else if (SeriesDataTypeKeys.SLA_SUCCEEDED_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView((io.atlassian.fugue.Option<DrillDownFieldView>)this.timeMetricsOption.flatMap(timeMetric -> this.getFieldViewForId(this.issue, CUSTOM_FIELD_ID_PREFIX + timeMetric.getCustomFieldId(), allAvailableFields))));
        } else if (SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView((io.atlassian.fugue.Option<DrillDownFieldView>)this.timeMetricsOption.flatMap(timeMetric -> this.getFieldViewForDuration(this.user, (io.atlassian.fugue.Option<Long>)io.atlassian.fugue.Option.option((Object)this.collectedIssue.getValue()), ELAPSED_TIME_CSS_CLASS))));
        } else if (SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((Object)DrillDownFieldView.getFieldView((io.atlassian.fugue.Option<DrillDownFieldView>)this.timeMetricsOption.flatMap(timeMetric -> this.getFieldViewForId(this.issue, CUSTOM_FIELD_ID_PREFIX + timeMetric.getCustomFieldId(), allAvailableFields))));
        }
        return row.build();
    }

    @Override
    public List<String> toCsvView() {
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.issue.getKey());
        row.add((String)io.atlassian.fugue.Option.option((Object)this.issue.getSummary()).getOrElse((Object)""));
        row.add((String)io.atlassian.fugue.Option.option((Object)this.issue.getReporter()).map(ApplicationUser::getDisplayName).getOrElse((Object)"Unassigned"));
        row.add((String)io.atlassian.fugue.Option.option((Object)this.issue.getAssignee()).map(ApplicationUser::getDisplayName).getOrElse((Object)"Unassigned"));
        row.add((String)this.getRequestType().map(RequestType::getName).getOrElse((Object)""));
        if (SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((String)io.atlassian.fugue.Option.option((Object)this.issue.getStatus()).map(IssueConstant::getName).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((String)io.atlassian.fugue.Option.option((Object)this.issue.getResolution()).map(IssueConstant::getName).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.AVERAGE_RATING_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((String)this.getRating().map(Object::toString).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.SLA_BREACHED_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            io.atlassian.fugue.Option<Long> breachedSlaSeriesValue = this.getBreachedSlaSeriesDrillDownValue();
            row.add((String)breachedSlaSeriesValue.map(breachedTime -> this.slaDurationFormatter.getShortFormattedRemainingDuration(breachedTime.longValue(), this.user)).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.SLA_SUCCEEDED_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            io.atlassian.fugue.Option<Long> metSlaSeriesValue = this.getMetSlaSeriesDrillDownValue();
            row.add((String)metSlaSeriesValue.map(remainingTime -> this.slaDurationFormatter.getShortFormattedRemainingDuration(remainingTime.longValue(), this.user)).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            row.add((String)io.atlassian.fugue.Option.option((Object)this.collectedIssue.getValue()).map(elapsedTime -> this.slaDurationFormatter.getShortFormattedRemainingDuration(elapsedTime.longValue(), this.user)).getOrElse((Object)""));
        } else if (SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY.equals((Object)this.seriesType)) {
            io.atlassian.fugue.Option<Long> percentageMetSlaSeriesValue = this.getPercentageMetSlaSeriesDrillDownValue();
            row.add((String)percentageMetSlaSeriesValue.map(remainingTime -> this.slaDurationFormatter.getShortFormattedRemainingDuration(remainingTime.longValue(), this.user)).getOrElse((Object)""));
        }
        return row;
    }

    private io.atlassian.fugue.Option<DrillDownFieldView> getFieldViewForId(Issue issue, String fieldId, Map<String, NavigableField> allAvailableFields) {
        return Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)allAvailableFields.get(fieldId))).then(navigableField -> this.mapFieldToFieldView(issue, (NavigableField)navigableField)).yield((field, drillDownView) -> drillDownView);
    }

    private Map<String, NavigableField> getAllAvailableFields() {
        HashMap<String, NavigableField> allAvailableFields = new HashMap<String, NavigableField>();
        try {
            Set navigableFields = this.fieldManager.getAvailableNavigableFields(this.user);
            for (NavigableField navigableField : navigableFields) {
                allAvailableFields.put(navigableField.getId(), navigableField);
            }
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
        return allAvailableFields;
    }

    private io.atlassian.fugue.Option<DrillDownFieldView> mapFieldToFieldView(Issue issue, NavigableField navigableField) {
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue);
        FieldLayoutItem fieldLayoutItem = fieldScreenRenderer.getFieldLayout().getFieldLayoutItem(navigableField.getId());
        return io.atlassian.fugue.Option.some((Object)new DrillDownFieldView(navigableField.getColumnViewHtml(fieldLayoutItem, new HashMap(), issue), navigableField.getColumnCssClass()));
    }

    private io.atlassian.fugue.Option<DrillDownFieldView> getFieldViewForDuration(ApplicationUser applicationUser, io.atlassian.fugue.Option<Long> duration, String cssClass) {
        if (duration.isEmpty()) {
            return io.atlassian.fugue.Option.none();
        }
        return io.atlassian.fugue.Option.some((Object)new DrillDownFieldView(this.slaDurationFormatter.getShortFormattedRemainingDuration(((Long)duration.get()).longValue(), applicationUser), cssClass));
    }

    private io.atlassian.fugue.Option<RequestType> getRequestType() {
        RequestTypeQuery requestTypeQuery = this.requestTypeService.newQueryBuilder().issue(this.issue.getId()).build();
        io.atlassian.fugue.Either requestType = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(this.user, requestTypeQuery)).map(PagedResponse::findFirst);
        if (requestType.isRight() && ((Optional)requestType.right().get()).isPresent()) {
            return io.atlassian.fugue.Option.some(((Optional)requestType.right().get()).get());
        }
        return io.atlassian.fugue.Option.none();
    }

    private io.atlassian.fugue.Option<Integer> getRating() {
        return this.requestFeedbackInternalService.getFeedback(this.issue).map(Feedback::getRating);
    }

    private io.atlassian.fugue.Option<SlaInformation> getSlaInformation(TimeMetric timeMetric) {
        SlaInformationQuery slaQuery = this.slaInformationService.newInfoQueryBuilder().issue(this.issue.getId()).id(Long.valueOf(timeMetric.getId().intValue())).build();
        return StepsConverters.newerEither((Either)this.slaInformationService.getInfo(this.user, slaQuery)).toOption().flatMap(pagedResponse -> StepsConverters.newerOption((Option)FpKit.toOption((Optional)pagedResponse.findFirst())));
    }

    private boolean hasNoSlaCycleInformation(SlaInformation slaInfo) {
        return !slaInfo.getOngoingCycle().isPresent() && slaInfo.getCompletedCycles().isEmpty();
    }

    private io.atlassian.fugue.Option<Long> getBreachedSlaSeriesDrillDownValue() {
        return this.timeMetricsOption.flatMap(this::getSlaInformation).flatMap(slaInformation -> {
            if (this.hasNoSlaCycleInformation((SlaInformation)slaInformation)) {
                return io.atlassian.fugue.Option.none();
            }
            if (slaInformation.getOngoingCycle().isPresent()) {
                SlaInformationOngoingCycle ongoingCycle = (SlaInformationOngoingCycle)slaInformation.getOngoingCycle().get();
                return io.atlassian.fugue.Option.option((Object)(ongoingCycle.getGoalDuration() - ongoingCycle.getElapsedTime()));
            }
            SlaInformationCompletedCycle lastCycle = (SlaInformationCompletedCycle)slaInformation.getCompletedCycles().get(slaInformation.getCompletedCycles().size() - 1);
            return io.atlassian.fugue.Option.option((Object)(lastCycle.getGoalDuration() - lastCycle.getElapsedTime()));
        });
    }

    private io.atlassian.fugue.Option<Long> getMetSlaSeriesDrillDownValue() {
        return this.timeMetricsOption.flatMap(this::getSlaInformation).flatMap(slaInformation -> {
            if (slaInformation.getCompletedCycles().isEmpty()) {
                return io.atlassian.fugue.Option.none();
            }
            SlaInformationCompletedCycle lastCycle = (SlaInformationCompletedCycle)slaInformation.getCompletedCycles().get(slaInformation.getCompletedCycles().size() - 1);
            return io.atlassian.fugue.Option.option((Object)lastCycle.getRemainingTime());
        });
    }

    private io.atlassian.fugue.Option<Long> getPercentageMetSlaSeriesDrillDownValue() {
        return this.timeMetricsOption.flatMap(this::getSlaInformation).flatMap(slaInformation -> {
            if (slaInformation.getCompletedCycles().isEmpty()) {
                return io.atlassian.fugue.Option.option((Object)((SlaInformationOngoingCycle)slaInformation.getOngoingCycle().get()).getRemainingTime());
            }
            return io.atlassian.fugue.Option.option((Object)((SlaInformationCompletedCycle)slaInformation.getCompletedCycles().get(slaInformation.getCompletedCycles().size() - 1)).getRemainingTime());
        });
    }
}

