/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldService;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetricService;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownQueryHelper;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportDrillDownQueryHelperImpl
implements ReportDrillDownQueryHelper {
    private final TimeMetricService timeMetricService;
    private final CustomFieldService customFieldService;

    @Autowired
    ReportDrillDownQueryHelperImpl(TimeMetricService timeMetricService, CustomFieldService customFieldService) {
        this.timeMetricService = timeMetricService;
        this.customFieldService = customFieldService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, TimeMetric> getTimeMetric(ApplicationUser user, ServiceDesk sd, Series series) {
        Long timeMetricId = series.getTimeMetricId();
        return StepsConverters.newerEither((Either)this.timeMetricService.getTimeMetric(user, sd, timeMetricId.intValue()));
    }

    @Override
    public Option<CustomField> getCustomField(@Nonnull TimeMetric timeMetric) {
        CustomField cf = this.customFieldService.getCustomField(timeMetric.getCustomFieldId());
        return Option.option((Object)cf);
    }
}

