/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series;

import com.atlassian.fugue.Either;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.ReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.ReportSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.series.SeriesData;
import com.atlassian.servicedesk.plugins.reports.internal.series.issue.RequestCreatedSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.series.kb.KBHelpfulSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.series.kb.KBViewSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportSeriesManagerImpl
implements ReportSeriesManager {
    private final KBHelpfulSeriesManager kbHelpfulSeriesManager;
    private final KBViewSeriesManager kbViewSeriesManager;
    private final RequestCreatedSeriesManager requestCreatedSeriesManager;
    private final ErrorResultHelper errorResultHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public ReportSeriesManagerImpl(KBHelpfulSeriesManager kbHelpfulSeriesManager, KBViewSeriesManager kbViewSeriesManager, RequestCreatedSeriesManager requestCreatedSeriesManager, ErrorResultHelper errorResultHelper, I18nHelper i18nHelper) {
        this.kbHelpfulSeriesManager = kbHelpfulSeriesManager;
        this.kbViewSeriesManager = kbViewSeriesManager;
        this.requestCreatedSeriesManager = requestCreatedSeriesManager;
        this.errorResultHelper = errorResultHelper;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ReportSeries> getReportSeriesData(String seriesId, ServiceDesk serviceDesk, Timescale timescale) {
        if (PredefinedReportSeries.KB_ARTICLE_VIEWS_SERIES.getId().equals(seriesId)) {
            return this.kbViewSeriesManager.getSeriesData(serviceDesk, timescale).map(seriesData -> this.createReportSeries(PredefinedReportSeries.KB_ARTICLE_VIEWS_SERIES, (SeriesData)seriesData));
        }
        if (PredefinedReportSeries.KB_HELPFUL_SERIES.getId().equals(seriesId)) {
            return this.kbHelpfulSeriesManager.getSeriesData(serviceDesk, timescale).map(seriesData -> this.createReportSeries(PredefinedReportSeries.KB_HELPFUL_SERIES, (SeriesData)seriesData));
        }
        if (PredefinedReportSeries.REQUEST_CREATED_SERIES.getId().equals(seriesId)) {
            return this.requestCreatedSeriesManager.getSeriesData(serviceDesk, timescale).map(seriesData -> this.createReportSeries(PredefinedReportSeries.REQUEST_CREATED_SERIES, (SeriesData)seriesData));
        }
        if (PredefinedReportSeries.KB_SOLVED_BY_SELF_SERVICE_SERIES.getId().equals(seriesId)) {
            return this.kbHelpfulSeriesManager.getSeriesData(serviceDesk, timescale).map(seriesData -> this.createReportSeries(PredefinedReportSeries.KB_SOLVED_BY_SELF_SERVICE_SERIES, (SeriesData)seriesData));
        }
        return StepsConverters.newerEither((Either)this.errorResultHelper.badRequest400("sd.project.reports.series.id.not.found", new Object[]{seriesId}).toEither());
    }

    private ReportSeries createReportSeries(PredefinedReportSeries predefinedReportSeries, SeriesData seriesData) {
        return new ReportSeries(predefinedReportSeries.getId(), predefinedReportSeries.getColor(), this.i18nHelper.getText(predefinedReportSeries.getI18nLabel()), seriesData);
    }
}

