/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest.response;

import com.atlassian.servicedesk.internal.api.report.SeriesDataType;
import com.atlassian.servicedesk.plugins.reports.internal.series.Point;
import com.atlassian.servicedesk.plugins.reports.internal.series.ReportSeries;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ReportSeriesResponse {
    private String seriesId;
    private String color;
    private List<Point> data;
    private Number seriesSummaryValue;
    private String label;
    private String yAxisType;
    private String jql;
    private Number reportId;
    private String seriesKey;
    private SeriesDataType seriesType;
    private Number timeMetricId;
    private String timeMetricIdOption;
    private Number goalId;

    public ReportSeriesResponse() {
    }

    public ReportSeriesResponse(String seriesId, String color, List<Point> data, Number seriesSummaryValue, String label, String yAxisType, String jql, Number reportId, String seriesKey, SeriesDataType seriesType, Number timeMetricId, String timeMetricIdOption, Number goalId) {
        this.seriesId = seriesId;
        this.color = color;
        this.data = data;
        this.seriesSummaryValue = seriesSummaryValue;
        this.label = label;
        this.yAxisType = yAxisType;
        this.jql = jql;
        this.reportId = reportId;
        this.seriesKey = seriesKey;
        this.seriesType = seriesType;
        this.timeMetricId = timeMetricId;
        this.timeMetricIdOption = timeMetricIdOption;
        this.goalId = goalId;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public String getColor() {
        return this.color;
    }

    public List<Point> getData() {
        return this.data;
    }

    public Number getSeriesSummaryValue() {
        return this.seriesSummaryValue;
    }

    public String getLabel() {
        return this.label;
    }

    public String getyAxisType() {
        return this.yAxisType;
    }

    public String getJql() {
        return this.jql;
    }

    public Number getReportId() {
        return this.reportId;
    }

    public String getSeriesKey() {
        return this.seriesKey;
    }

    public SeriesDataType getSeriesType() {
        return this.seriesType;
    }

    public Number getTimeMetricId() {
        return this.timeMetricId;
    }

    public String getTimeMetricIdOption() {
        return this.timeMetricIdOption;
    }

    public void setSeriesId(String seriesId) {
        this.seriesId = seriesId;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setData(List<Point> data) {
        this.data = data;
    }

    public void setSeriesSummaryValue(Number seriesSummaryValue) {
        this.seriesSummaryValue = seriesSummaryValue;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setyAxisType(String yAxisType) {
        this.yAxisType = yAxisType;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public void setReportId(Number reportId) {
        this.reportId = reportId;
    }

    public void setSeriesKey(String seriesKey) {
        this.seriesKey = seriesKey;
    }

    public void setSeriesType(SeriesDataType seriesType) {
        this.seriesType = seriesType;
    }

    public void setTimeMetricId(Number timeMetricId) {
        this.timeMetricId = timeMetricId;
    }

    public void setTimeMetricIdOption(String timeMetricIdOption) {
        this.timeMetricIdOption = timeMetricIdOption;
    }

    public Number getGoalId() {
        return this.goalId;
    }

    public void setGoalId(Number goalId) {
        this.goalId = goalId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String seriesId;
        private String color;
        private List<Point> data;
        private Number seriesSummaryValue;
        private String label;
        private String yAxisType;
        private String jql;
        private Number reportId;
        private String seriesKey;
        private SeriesDataType seriesType;
        private Number timeMetricId;
        private String timeMetricIdOption;
        private Number goalId;

        private Builder() {
        }

        public Builder withSeriesId(String value) {
            this.seriesId = value;
            return this;
        }

        public Builder withColor(String value) {
            this.color = value;
            return this;
        }

        public Builder withData(List<Point> points) {
            this.data = points;
            return this;
        }

        public Builder withSummaryValue(Number summaryValue) {
            this.seriesSummaryValue = summaryValue;
            return this;
        }

        public Builder withLabel(String value) {
            this.label = value;
            return this;
        }

        public Builder withYAxisType(String value) {
            this.yAxisType = value;
            return this;
        }

        public Builder withJql(String value) {
            this.jql = value;
            return this;
        }

        public Builder withReportId(Number value) {
            this.reportId = value;
            return this;
        }

        public Builder withSeriesKey(String value) {
            this.seriesKey = value;
            return this;
        }

        public Builder withSeriesType(SeriesDataType value) {
            this.seriesType = value;
            return this;
        }

        public Builder withTimeMetricId(Number value) {
            this.timeMetricId = value;
            return this;
        }

        public Builder withTimeMetricIdOption(String value) {
            this.timeMetricIdOption = value;
            return this;
        }

        public Builder withGoalId(Number value) {
            this.goalId = value;
            return this;
        }

        public Builder withReportSeries(ReportSeries reportSeries) {
            this.seriesId = reportSeries.getSeriesId();
            this.color = reportSeries.getColor();
            this.data = reportSeries.getSeriesData().getData();
            this.seriesSummaryValue = reportSeries.getSeriesData().getSeriesSummaryValue();
            this.label = reportSeries.getLabel();
            this.yAxisType = reportSeries.getSeriesData().getYAxisType().getStringFormat();
            return this;
        }

        public ReportSeriesResponse build() {
            return new ReportSeriesResponse(this.seriesId, this.color, this.data, this.seriesSummaryValue, this.label, this.yAxisType, this.jql, this.reportId, this.seriesKey, this.seriesType, this.timeMetricId, this.timeMetricIdOption, this.goalId);
        }
    }
}

