/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.reports.internal.ReportService;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsBaseResource;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.TimeBreakdown;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.UserTimeZoneService;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

@Path(value="pages/reports/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReportsPageResource
extends ReportsBaseResource {
    private static final Period DEFAULT_TIME_PERIOD_7_DAYS = Period.days((int)7);
    private static final TimeBreakdown DEFAULT_TIME_BREAKDOWN_DAY = TimeBreakdown.DAY;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserTimeZoneService userTimeZoneService;
    private final ServiceDeskService serviceDeskService;
    private final ReportService reportService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    public ReportsPageResource(JiraAuthenticationContext jiraAuthenticationContext, UserTimeZoneService userTimeZoneService, ProjectService projectService, ServiceDeskService serviceDeskService, ReportService reportService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        super(projectService);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userTimeZoneService = userTimeZoneService;
        this.serviceDeskService = serviceDeskService;
        this.reportService = reportService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @GET
    @Path(value="/{reportId}")
    public Response getReportData(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @QueryParam(value="timePeriod") String timePeriodStr, @QueryParam(value="timeBreakdown") String timeBreakdownStr) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        io.atlassian.fugue.Either result = Steps.begin(this.parsePeriod(timePeriodStr)).then(timePeriod -> this.parseTimeBreakdown(timeBreakdownStr)).then((timePeriod, timeBreakdown) -> this.retrieveReportData(user, projectKey, reportId, (Period)timePeriod, (TimeBreakdown)((Object)timeBreakdown))).yield((timePeriod, timeBreakdown, data) -> data);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, Timescale> getTimescaleForUserWithEndDateNow(ApplicationUser user, Period timePeriod, TimeBreakdown timeBreakdown) {
        DateTimeZone userTimeZone = this.userTimeZoneService.getUserDateTimeZone(user);
        long currentTimeMillis = System.currentTimeMillis();
        return Timescale.createTimescale(timePeriod, timeBreakdown, currentTimeMillis, userTimeZone, this.errorResultHelper);
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> retrieveReportData(ApplicationUser user, String projectKey, String reportId, Period period, TimeBreakdown timeBreakdown) {
        return Steps.begin(this.getTimescaleForUserWithEndDateNow(user, period, timeBreakdown)).then(timescale -> this.getProject(projectKey)).then((timescale, project) -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then((timescale, project, sd) -> this.reportService.getReport(user, reportId, (ServiceDesk)sd, (Timescale)timescale)).yield((timescale, project, sd, report) -> report);
    }

    private io.atlassian.fugue.Either<AnError, Period> parsePeriod(@Nullable String periodStr) {
        try {
            if (periodStr == null) {
                return io.atlassian.fugue.Either.right((Object)DEFAULT_TIME_PERIOD_7_DAYS);
            }
            return io.atlassian.fugue.Either.right((Object)Period.parse((String)periodStr));
        }
        catch (IllegalArgumentException e) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.project.reports.timeperiod.invalid", new Object[]{periodStr}).build());
        }
    }

    private io.atlassian.fugue.Either<AnError, TimeBreakdown> parseTimeBreakdown(@Nullable String timeBreakdownStr) {
        if (timeBreakdownStr == null) {
            return io.atlassian.fugue.Either.right((Object)((Object)DEFAULT_TIME_BREAKDOWN_DAY));
        }
        return TimeBreakdown.parse(timeBreakdownStr).toRight(() -> this.errorResultHelper.badRequest400("sd.project.reports.timebreakdown.invalid", new Object[]{timeBreakdownStr}).build());
    }
}

