/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownColumnHeading;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ReportsDrilldownResourceHelper {
    public List<DrillDownColumnHeading> getColumnNamesForPredefinedSeries(String seriesId, I18nHelper i18nHelper) {
        List<String> columnI18nKeys;
        if (PredefinedReportSeries.NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES.getId().equals(seriesId)) {
            columnI18nKeys = PredefinedReportSeries.NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES.getDrilldownI18nKeys();
        } else if (PredefinedReportSeries.NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES.getId().equals(seriesId)) {
            columnI18nKeys = PredefinedReportSeries.NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES.getDrilldownI18nKeys();
        } else if (PredefinedReportSeries.NEW_KB_REQUESTS_SOLVED_BY_AGENTS_SHARING_SERIES.getId().equals(seriesId)) {
            columnI18nKeys = PredefinedReportSeries.NEW_KB_REQUESTS_SOLVED_BY_AGENTS_SHARING_SERIES.getDrilldownI18nKeys();
        } else if (PredefinedReportSeries.NEW_KB_REQUESTS_SOLVED_BY_AGENTS_WITHOUT_SHARING_SERIES.getId().equals(seriesId)) {
            columnI18nKeys = PredefinedReportSeries.NEW_KB_REQUESTS_SOLVED_BY_AGENTS_WITHOUT_SHARING_SERIES.getDrilldownI18nKeys();
        } else {
            return Collections.emptyList();
        }
        return this.getAllI18nStrings(columnI18nKeys, i18nHelper);
    }

    private List<DrillDownColumnHeading> getAllI18nStrings(List<String> i18nKeys, I18nHelper i18nHelper) {
        return i18nKeys.stream().map(i18nKey -> new DrillDownColumnHeading(i18nHelper.getText(i18nKey))).collect(Collectors.toList());
    }
}

