/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.report.series.SeriesService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.reports.internal.helper.ReportTimescaleConversionHelper;
import com.atlassian.servicedesk.plugins.reports.internal.i18n.CommonI18n;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsBaseResource;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsDrilldownResourceHelper;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportsDrilldownDTO;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownColumnHeading;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownFieldView;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownPagedData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownQueryHelper;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownService;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.UserTimeZoneService;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="servicedesk/{projectKey}/series/{seriesId}/drilldown")
public class ReportsDrilldownResource
extends ReportsBaseResource {
    private final ReportDrillDownService reportDrillDownService;
    private final ServiceDeskService serviceDeskService;
    private final UserTimeZoneService userTimeZoneService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final CommonI18n commonI18n;
    private final ReportDrillDownQueryHelper reportDrillDownQueryHelper;
    private final SeriesService seriesService;
    private final ReportsDrilldownResourceHelper reportsDrilldownResourceHelper;
    private final ReportTimescaleConversionHelper reportTimescaleConversionHelper;

    public ReportsDrilldownResource(UserFactory userFactory, ReportDrillDownService reportDrillDownService, ServiceDeskService serviceDeskService, ProjectService projectService, UserTimeZoneService userTimeZoneService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper, CommonI18n commonI18n, ReportDrillDownQueryHelper reportDrillDownQueryHelper, SeriesService seriesService, ReportsDrilldownResourceHelper reportsDrilldownResourceHelper, ReportTimescaleConversionHelper reportTimescaleConversionHelper) {
        super(projectService);
        this.reportDrillDownService = reportDrillDownService;
        this.serviceDeskService = serviceDeskService;
        this.userTimeZoneService = userTimeZoneService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.commonI18n = commonI18n;
        this.reportDrillDownQueryHelper = reportDrillDownQueryHelper;
        this.seriesService = seriesService;
        this.reportsDrilldownResourceHelper = reportsDrilldownResourceHelper;
        this.reportTimescaleConversionHelper = reportTimescaleConversionHelper;
    }

    @GET
    public Response getDrilldown(@PathParam(value="projectKey") String projectKey, @PathParam(value="seriesId") long seriesId, @QueryParam(value="date") long date, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit, @QueryParam(value="timescaleId") long timescaleId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        PagedRequest pagedRequest = SimplePagedRequest.paged((int)start, (int)limit);
        DateTimeZone timeZone = this.userTimeZoneService.getUserDateTimeZone(user.forJIRA());
        io.atlassian.fugue.Either series = Steps.begin(this.getProject(projectKey)).then(project -> this.getSeries(user.forJIRA(), projectKey, seriesId)).yield((project, result) -> result);
        if (series.isLeft()) {
            return this.restResponseHelper.anErrorToResponse((AnError)series.left().get());
        }
        if (series.right().isEmpty()) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.notFound404("sd.project.reports.series.id.not.found", new Object[]{seriesId}).build());
        }
        Option<String> columnHeading = this.getColumnHeading((Series)series.right().get(), projectKey, user);
        io.atlassian.fugue.Either response = Steps.begin(this.getProject(projectKey)).then(project -> this.getTimescaleFromId(date, timescaleId)).then((project, reportTimescale) -> this.reportTimescaleConversionHelper.convertFromTimescaleId(timescaleId, new DateTime(date), timeZone)).then((project, reportTimescale, timescale) -> this.reportDrillDownService.getDrillDownPagedData(user.forJIRA(), (Project)project, (Timescale)timescale, seriesId, pagedRequest).map(pagedData -> this.customReportPagedDataToResponse((ReportDrillDownPagedData)pagedData, ((Series)series.right().get()).getSeriesType().getTypeKey(), columnHeading))).yield((project, reportTimescale, timescale, result) -> result);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    @GET
    @Path(value="/predefined")
    public Response getDrilldown(@PathParam(value="projectKey") String projectKey, @PathParam(value="seriesId") String seriesId, @QueryParam(value="date") long date, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit, @QueryParam(value="timescaleId") long timescaleId) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        PagedRequest pagedRequest = SimplePagedRequest.paged((int)start, (int)limit);
        io.atlassian.fugue.Either response = Steps.begin(this.getProject(projectKey)).then(project -> this.getTimescaleFromId(date, timescaleId)).then((project, timescale) -> this.reportDrillDownService.getDrillDownPagedData(user.forJIRA(), (Project)project, (Timescale)timescale, seriesId, pagedRequest).map(pagedData -> this.predefinedSeriesPagedDataToResponse((ReportDrillDownPagedData)pagedData, seriesId, user.i18NHelper()))).yield((project, timescale, result) -> result);
        return this.restResponseHelper.anErrorEitherToOkResponse(response);
    }

    private Option<String> getColumnHeading(Series series, String projectKey, UncheckedUser user) {
        Option columnHeading = Option.none();
        if (SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY.getTypeKey().equals(series.getSeriesType().getTypeKey())) {
            io.atlassian.fugue.Either timeMetric = Steps.begin(this.getProject(projectKey)).then(project -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project))).then((project, serviceDesk) -> this.reportDrillDownQueryHelper.getTimeMetric(user.forJIRA(), (ServiceDesk)serviceDesk, series)).yield((project, serviceDesk, result) -> result);
            if (timeMetric.isLeft()) {
                return Option.none();
            }
            columnHeading = Option.some((Object)((TimeMetric)timeMetric.right().get()).getName());
        }
        return columnHeading;
    }

    private ReportsDrilldownDTO predefinedSeriesPagedDataToResponse(ReportDrillDownPagedData pagedData, String seriesId, I18nHelper i18nHelper) {
        List<DrillDownColumnHeading> columnNames = this.reportsDrilldownResourceHelper.getColumnNamesForPredefinedSeries(seriesId, i18nHelper);
        return this.buildResponse(pagedData, columnNames);
    }

    private ReportsDrilldownDTO customReportPagedDataToResponse(ReportDrillDownPagedData pagedData, String seriesType, Option<String> columnHeading) {
        List<DrillDownColumnHeading> columnNames = this.amendColumnNamesBySeriesType(seriesType, columnHeading);
        return this.buildResponse(pagedData, columnNames);
    }

    private ReportsDrilldownDTO buildResponse(ReportDrillDownPagedData pagedData, List<DrillDownColumnHeading> columnNames) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (ReportDrillDownItem item : pagedData.getResults()) {
            List<DrillDownFieldView> row = item.toDrillDownFieldView();
            rows.add(row);
        }
        return new ReportsDrilldownDTO(columnNames, (List<List<DrillDownFieldView>>)rows.build(), pagedData.getTotal(), pagedData.getPageSize());
    }

    private List<DrillDownColumnHeading> amendColumnNamesBySeriesType(String seriesType, Option<String> columnHeading) {
        List<DrillDownColumnHeading> columnNames = this.commonI18n.COMMON_COLUMNS().stream().map(DrillDownColumnHeading::new).collect(Collectors.toList());
        if (SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.ISSUE_STATUS()));
        } else if (SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.ISSUE_RESOLUTION()));
        } else if (SeriesDataTypeKeys.AVERAGE_RATING_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.REQUEST_CSAT()));
        } else if (SeriesDataTypeKeys.SLA_BREACHED_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.SLA_BREACHED()));
        } else if (SeriesDataTypeKeys.SLA_SUCCEEDED_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.SLA_MET()));
        } else if (SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(new DrillDownColumnHeading(this.commonI18n.SLA_ELAPSED()));
        } else if (columnHeading.isDefined()) {
            columnNames.add(new DrillDownColumnHeading((String)columnHeading.get()));
        }
        return columnNames;
    }

    private io.atlassian.fugue.Either<AnError, Series> getSeries(ApplicationUser user, String projectKey, long seriesId) {
        return Steps.begin(this.getProject(projectKey)).then(project -> StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then((project, checkedUser) -> this.seriesService.getSeries(checkedUser, project, seriesId)).yield((project, checkedUser, series) -> series);
    }

    private io.atlassian.fugue.Either<AnError, Timescale> getTimescaleFromId(Long date, Long timescaleId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.reportTimescaleConversionHelper.convertFromTimescaleId(timescaleId, new DateTime((Object)date), this.userTimeZoneService.getUserDateTimeZone(user.forJIRA()))).yield((user, result) -> result);
    }
}

