/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.status.RunOutcome;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.StatsEventDatabaseShredder;
import io.atlassian.fugue.Option;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="/cleanup")
@Internal
public class ReportsCleanupResource {
    private final StatsEventDatabaseShredder statsEventDatabaseShredder;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public ReportsCleanupResource(StatsEventDatabaseShredder statsEventDatabaseShredder, GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.statsEventDatabaseShredder = statsEventDatabaseShredder;
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @DELETE
    public Response executeDataCleanup() {
        return (Response)Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser()).fold(() -> Response.status((Response.Status)Response.Status.UNAUTHORIZED).build(), user -> {
            if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            JobRunnerResponse jobRunnerResponse = this.statsEventDatabaseShredder.executeCleanup();
            String message = jobRunnerResponse.getMessage();
            if (jobRunnerResponse.getRunOutcome().equals((Object)RunOutcome.SUCCESS)) {
                return Response.ok((Object)message).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)message).build();
        });
    }
}

