/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.sla.configuration.calendar.CalendarReferenceManager;
import com.atlassian.servicedesk.internal.api.sla.goal.Goal;
import com.atlassian.servicedesk.internal.api.sla.goal.GoalService;
import com.atlassian.servicedesk.internal.api.sla.metric.CalculatorLookup;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.ReportQueries;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup.CalculatorLookupImpl;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup.CalculatorLookupService;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup.IssueIdToGoalCallback;
import io.atlassian.fugue.Option;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class CalculatorLookupServiceImpl
implements CalculatorLookupService {
    private final IssueDataService issueDataService;
    private final SearchService searchService;
    private final ReportQueries reportQueries;
    private final CalendarReferenceManager calendarReferenceManager;
    private final GoalService goalService;

    @Autowired
    public CalculatorLookupServiceImpl(IssueDataService issueDataService, SearchService searchService, ReportQueries reportQueries, CalendarReferenceManager calendarReferenceManager, GoalService goalService) {
        this.issueDataService = issueDataService;
        this.searchService = searchService;
        this.reportQueries = reportQueries;
        this.calendarReferenceManager = calendarReferenceManager;
        this.goalService = goalService;
    }

    @Override
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
    public CalculatorLookup getCalculatorLookup(CheckedUser user, ServiceDesk serviceDesk, TimeMetric timeMetric, Query query, org.apache.lucene.search.Query luceneQuery) {
        WorkingHoursCalculator defaultCalculator = this.calendarReferenceManager.getDefaultCalculator();
        IssueIdToGoalCallback callback = new IssueIdToGoalCallback(defaultCalculator);
        Collection goals = this.goalService.getGoals(user.forJIRA(), serviceDesk, timeMetric);
        for (Goal goal : goals) {
            WorkingHoursCalculator calculator = this.calendarReferenceManager.getCalculatorForGoal(goal);
            callback.setCalculator(calculator);
            Query goalQuery = this.getQueryForGoal(user, query, goal);
            this.issueDataService.find(user.forJIRA(), goalQuery, (DataCallback)callback, luceneQuery);
        }
        return new CalculatorLookupImpl(callback.issueIdToCalculator, defaultCalculator);
    }

    private Query getQueryForGoal(CheckedUser user, Query query, Goal goal) {
        Option<Query> goalQuery = this.reportQueries.getQueryFromString(this.searchService, user.forJIRA(), goal.getJqlQuery());
        return this.reportQueries.joinQueries(goalQuery, query);
    }
}

