/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.reportdata;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.operator.Operator;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.SeriesDataType;
import com.atlassian.servicedesk.internal.api.sla.SLAAccessorService;
import com.atlassian.servicedesk.internal.api.sla.searcher.TimelineCycleState;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilder;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilderFactory;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.ReportQueries;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportQueriesImpl
implements ReportQueries {
    private final SLAAccessorService slaAccessorService;

    @Autowired
    public ReportQueriesImpl(SLAAccessorService slaAccessorService) {
        this.slaAccessorService = slaAccessorService;
    }

    @Override
    public Query issueCreatedQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate) {
        return JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()}).and().createdBetween(this.sDate(startDate), this.eDate(endDate)).buildQuery();
    }

    @Override
    public Query issueResolutionDateQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate) {
        return JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()}).and().resolution().isNotEmpty().and().resolutionDateBetween(this.sDate(startDate), this.eDate(endDate)).buildQuery();
    }

    @Override
    public Query timeMetricQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate) {
        return JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()}).buildQuery();
    }

    @Override
    public Query slaSucceededQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate, Option<CustomField> cfOpt) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()});
        for (CustomField cf : cfOpt) {
            builder.and().addFunctionCondition(cf.getName(), Operator.NOT_EQUALS, "breached").and().addFunctionCondition(cf.getName(), Operator.EQUALS, "completed");
        }
        return builder.buildQuery();
    }

    @Override
    public Query slaBreachedQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate, Option<CustomField> cfOpt) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()});
        for (CustomField cf : cfOpt) {
            builder.and().addFunctionCondition(cf.getName(), Operator.EQUALS, "breached");
        }
        return builder.buildQuery();
    }

    @Override
    public Query slaSucceededAndBreachedQuery(ServiceDesk serviceDesk, Option<CustomField> cfOpt) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()});
        for (CustomField cf : cfOpt) {
            builder.and().sub().sub().addFunctionCondition(cf.getName(), Operator.NOT_EQUALS, "breached").and().addFunctionCondition(cf.getName(), Operator.EQUALS, "completed").endsub().or().addFunctionCondition(cf.getName(), Operator.EQUALS, "breached").endsub();
        }
        return builder.buildQuery();
    }

    @Override
    public Query allSlaQuery(ServiceDesk serviceDesk, DateTime startDate, DateTime endDate, Option<CustomField> cfOpt) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().project(new Long[]{serviceDesk.getProjectId()});
        for (CustomField cf : cfOpt) {
            JqlClauseBuilder allSlaBuilder = JqlQueryBuilder.newClauseBuilder().addFunctionCondition(cf.getName(), Operator.EQUALS, "breached").or().addFunctionCondition(cf.getName(), Operator.EQUALS, "completed").or().addFunctionCondition(cf.getName(), Operator.EQUALS, "running");
            builder.and().addClause(allSlaBuilder.buildClause());
        }
        return builder.buildQuery();
    }

    @Override
    public Option<Query> getQueryFromString(SearchService searchService, ApplicationUser user, String query) {
        SearchService.ParseResult parseResult = searchService.parseQuery(user, query);
        if (parseResult.isValid()) {
            return Option.some((Object)parseResult.getQuery());
        }
        return Option.none();
    }

    @Override
    public Option<Query> getQueryFromSeries(SearchService searchService, ApplicationUser user, ServiceDesk serviceDesk, Series series) {
        if (SeriesDataType.isTimeMetricType((SeriesDataType)series.getSeriesType()) && series.getTimeMetricIdOption().isDefined() && series.getGoalIdOption().isDefined()) {
            Option goalOpt = this.slaAccessorService.getGoal(user, serviceDesk, series.getTimeMetricId().intValue(), series.getGoalId().intValue());
            return Steps.begin((Option)goalOpt).then(goal -> this.getQueryFromString(searchService, user, goal.getJqlQuery())).yield((goal, query) -> query);
        }
        return this.getQueryFromString(searchService, user, series.getJql());
    }

    @Override
    public Query joinQueries(Option<Query> serviceQueryOpt, Query reportQuery) {
        return (Query)serviceQueryOpt.map(seriesQuery -> {
            Clause clause = JqlQueryBuilder.newClauseBuilder((Query)reportQuery).buildClause();
            return JqlQueryBuilder.newClauseBuilder((Query)seriesQuery).and().addClause(clause).buildQuery();
        }).getOrElse((Object)reportQuery);
    }

    @Override
    public org.apache.lucene.search.Query buildTimelineEndDateLuceneQuery(CustomField cf, DateTime startDate, DateTime endDate, SlaQueryBuilderFactory slaQueryBuilderFactory) {
        SlaQueryBuilder slaQueryBuilder = slaQueryBuilderFactory.newBuilder(cf);
        slaQueryBuilder.or();
        slaQueryBuilder.timelineCycleState(TimelineCycleState.ONGOING);
        slaQueryBuilder.sub().and();
        slaQueryBuilder.timelineCycleState(TimelineCycleState.COMPLETED);
        slaQueryBuilder.lastTimelineCycleEndDate().gtEq().date(startDate);
        slaQueryBuilder.lastTimelineCycleEndDate().ltEq().date(endDate);
        slaQueryBuilder.endSub();
        return slaQueryBuilder.build();
    }

    private Date sDate(DateTime startDate) {
        return startDate.toDate();
    }

    private Date eDate(DateTime endDate) {
        return endDate.minuteOfHour().roundCeilingCopy().toDate();
    }
}

