/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.reportdata;

import com.atlassian.servicedesk.plugins.reports.internal.collector.CollectorUtils;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.IntervalValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.Interval;

public class PercentageUtils {
    public static DataCollectorResult<Double> calculatePercentage(DataCollectorResult data, DataCollectorResult allData) {
        ArrayList aggregatedValues = new ArrayList();
        HashMap<Interval, Object> valueOverDates = new HashMap<Interval, Object>();
        List intervalValues = data.getIntervalValues();
        for (IntervalValue intervalValue : intervalValues) {
            valueOverDates.put(intervalValue.getInterval(), intervalValue.getValue());
        }
        List allIntervalValues = allData.getIntervalValues();
        for (IntervalValue intervalValue : allIntervalValues) {
            Double aggregatedValue = CollectorUtils.safeDivide((Long)((Number)valueOverDates.getOrDefault(intervalValue.getInterval(), 0L)).longValue(), (Long)intervalValue.getValue(), 0.0);
            IntervalValue<Double> newIntervalValue = new IntervalValue<Double>(intervalValue.getInterval(), aggregatedValue);
            aggregatedValues.add(newIntervalValue);
        }
        Double d = CollectorUtils.safeDivide((Long)((Number)data.getSeriesSummaryValue()).longValue(), (Long)((Number)allData.getSeriesSummaryValue()).longValue(), 0.0);
        return new DataCollectorResult<Double>(aggregatedValues, d);
    }
}

