/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.model;

import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;

public enum PredefinedReport {
    KB_USAGE_REPORT("kb-usage", Lists.newArrayList((Object[])new PredefinedReportSeries[]{PredefinedReportSeries.KB_ARTICLE_VIEWS_SERIES, PredefinedReportSeries.KB_HELPFUL_SERIES})),
    KB_SELF_SERVICE_REPORT("kb-self-service", Lists.newArrayList((Object[])new PredefinedReportSeries[]{PredefinedReportSeries.KB_ARTICLE_VIEWS_SERIES, PredefinedReportSeries.KB_SOLVED_BY_SELF_SERVICE_SERIES})),
    KB_EFFECTIVENESS_REPORT("kb-effectiveness", Lists.newArrayList((Object[])new PredefinedReportSeries[]{PredefinedReportSeries.KB_HELPFUL_SERIES, PredefinedReportSeries.REQUEST_CREATED_SERIES})),
    KB_ARTICLE_HELPFULNESS_REPORT("kb-article-helpfulness", Lists.newArrayList((Object[])new PredefinedReportSeries[]{PredefinedReportSeries.KB_SOLVED_BY_SELF_SERVICE_SERIES}));

    private final String id;
    private final List<PredefinedReportSeries> series;

    private PredefinedReport(String id, List<PredefinedReportSeries> series) {
        this.id = id;
        this.series = series;
    }

    public String getId() {
        return this.id;
    }

    public List<PredefinedReportSeries> getSeries() {
        return this.series;
    }

    public static Option<PredefinedReport> fromId(String reportId) {
        return Option.fromOptional(Lists.newArrayList((Object[])PredefinedReport.values()).stream().filter(report -> report.getId().equals(reportId)).findFirst());
    }
}

