/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.listener.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.reports.internal.dao.kb.KBViewAggregateDao;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.KBEventFactory;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessor;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KBViewEventProcessor
implements EventProcessor {
    private static final Set<String> SUPPORTED_KEYS = Sets.newHashSet((Object[])new String[]{"stats.event.kb.page.viewed"});
    private final KBEventFactory kbEventFactory;
    private final KBViewAggregateDao kbViewAggregateDao;

    @Autowired
    public KBViewEventProcessor(KBEventFactory kbEventFactory, KBViewAggregateDao kbViewAggregateDao) {
        this.kbEventFactory = kbEventFactory;
        this.kbViewAggregateDao = kbViewAggregateDao;
    }

    @Override
    @Nonnull
    public Set<String> supportedEventKeys() {
        return SUPPORTED_KEYS;
    }

    @Override
    @Nonnull
    public Either<AnError, StatsEvent> processEvent(@Nonnull StatsEvent event) {
        return Steps.begin(this.kbEventFactory.toKbViewEvent(event)).then(this.kbViewAggregateDao::aggregateEvent).yield((kbEvent, processedKbEvent) -> event);
    }
}

