/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.domain.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEventErrors;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.KBEventFactory;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.KBHelpfulEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.KBViewEvent;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KBEventFactoryImpl
implements KBEventFactory {
    static final String SERVICE_DESK_IDS = "service_desk_ids";
    private final StatsEventErrors statsEventErrors;

    @Autowired
    public KBEventFactoryImpl(StatsEventErrors statsEventErrors) {
        this.statsEventErrors = statsEventErrors;
    }

    @Override
    @Nonnull
    public Either<AnError, KBHelpfulEvent> toKbHelpfulEvent(@Nonnull StatsEvent statsEvent) {
        return Steps.begin(this.checkPropertiesIsNotBlank(statsEvent.getEventParams(), SERVICE_DESK_IDS)).then(u -> this.parseServiceDeskIds(statsEvent.getEventParams().get(SERVICE_DESK_IDS))).yield((u, serviceDeskIds) -> new KBHelpfulEvent(statsEvent.getEventTime(), (List<Long>)serviceDeskIds));
    }

    @Override
    @Nonnull
    public Either<AnError, KBViewEvent> toKbViewEvent(@Nonnull StatsEvent statsEvent) {
        return Steps.begin(this.checkPropertiesIsNotBlank(statsEvent.getEventParams(), SERVICE_DESK_IDS)).then(u -> this.parseServiceDeskIds(statsEvent.getEventParams().get(SERVICE_DESK_IDS))).yield((u, serviceDeskIds) -> new KBViewEvent(statsEvent.getEventTime(), (List<Long>)serviceDeskIds));
    }

    private Either<AnError, Unit> checkPropertiesIsNotBlank(@Nonnull Map<String, String> properties, String ... propertyIds) {
        for (String propertyId : propertyIds) {
            if (!StringUtils.isBlank((String)properties.get(propertyId))) continue;
            return Either.left((Object)this.buildEventConversionError());
        }
        return Either.right((Object)Unit.VALUE);
    }

    private Either<AnError, List<Long>> parseServiceDeskIds(@Nonnull String serviceDeskIdsString) {
        try {
            String[] serviceDeskIdStringArray = serviceDeskIdsString.split(",");
            if (serviceDeskIdStringArray.length == 0) {
                return Either.left((Object)this.buildEventConversionError());
            }
            List<Long> serviceDeskIds = this.convertIdsToLongs(serviceDeskIdStringArray);
            return Either.right(serviceDeskIds);
        }
        catch (NumberFormatException ex) {
            return Either.left((Object)this.buildEventConversionError());
        }
    }

    private List<Long> convertIdsToLongs(String[] serviceDeskIdStringArray) {
        ArrayList serviceDeskIds = Lists.newArrayList();
        for (String serviceDeskId : serviceDeskIdStringArray) {
            serviceDeskIds.add(Long.parseLong(serviceDeskId));
        }
        return serviceDeskIds;
    }

    private AnError buildEventConversionError() {
        return this.statsEventErrors.eventConversionError(StatsEvent.class, KBHelpfulEvent.class);
    }
}

